<?php
session_start();
include '../config/koneksi.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
$userId = $_SESSION['user_id'];

// Ambil data riwayat pemesanan user
$q = mysqli_query($conn, "SELECT p.*, k.tipe, k.gambar FROM pemesanan p JOIN kamar k ON p.id_kamar = k.id WHERE p.id_user = $userId ORDER BY p.id DESC");
$pemesananList = [];
while($row = mysqli_fetch_assoc($q)) {
    $pemesananList[] = $row;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Pemesanan - AngMansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { background: #f4f8ff; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; min-height: 100vh; display: flex; flex-direction: column; }
        .container { max-width: 900px; margin: 40px auto; background: #fff; border-radius: 18px; box-shadow: 0 4px 20px rgba(30,42,120,0.08); padding: 32px; }
        .riwayat-title { font-size: 2em; font-weight: 800; color: #1e2a78; margin-bottom: 24px; }
        .riwayat-table { width: 100%; border-collapse: collapse; margin-bottom: 24px; }
        .riwayat-table th, .riwayat-table td { padding: 12px 10px; border-bottom: 1px solid #e0eaff; text-align: left; }
        .riwayat-table th { background: #f4f8ff; color: #3a5eff; font-weight: 700; }
        .riwayat-table td img { width: 80px; height: 60px; object-fit: cover; border-radius: 8px; }
        .badge-status { font-size: 0.95em; font-weight: 600; border-radius: 20px; padding: 6px 16px; display: inline-block; }
        .badge-pending { background: #fff3cd; color: #856404; border: 1px solid #ffeeba; }
        .badge-sukses { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .badge-batal { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .badge-lain { background: #e2e3e5; color: #383d41; border: 1px solid #d6d8db; }
        .btn-detail { border: 2px solid #3a5eff; color: #3a5eff; background: #fff; border-radius: 8px; padding: 6px 16px; font-weight: 600; text-decoration: none; transition: background 0.2s, color 0.2s; }
        .btn-detail:hover { background: #3a5eff; color: #fff; }
        .timer-status { font-size: 1em; color: #c00; margin-top: 4px; font-weight: 500; }
        .footer-dark { margin-top: auto; }
    </style>
</head>
<body>
<?php
$isLogin = isset($_SESSION['user_id']);
$userNama = $isLogin ? $_SESSION['user_nama'] : '';
$user = null;
if($isLogin){
    $userId = $_SESSION['user_id'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}
$activePage = 'riwayat';
include 'header.php';
?>
<div class="container">
    <div class="riwayat-title">Riwayat Pemesanan Anda</div>
    <table class="riwayat-table">
        <thead>
            <tr>
                <th>Gambar</th>
                <th>Tipe Kamar</th>
                <th>Tgl Pesan</th>
                <th>Tgl Masuk</th>
                <th>Tgl Keluar</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
        <?php if(empty($pemesananList)): ?>
            <tr><td colspan="7" style="text-align:center;color:#888;">Belum ada riwayat pemesanan.</td></tr>
        <?php else: foreach($pemesananList as $i => $p): ?>
            <?php
            // Tambahan untuk menghindari error undefined variable
            $now = date('Y-m-d H:i:s');
            $batasBayar = isset($p['batas_bayar']) ? $p['batas_bayar'] : null;
            ?>
            <tr>
                <td><img src="../assets/images/<?= $p['gambar'] ? htmlspecialchars($p['gambar']) : 'angMansion.jpg' ?>" alt="<?= htmlspecialchars($p['tipe']) ?>" onerror="this.onerror=null;this.src='../assets/images/angMansion.jpg';"></td>
                <td><?= htmlspecialchars($p['tipe']) ?></td>
                <td><?= date('d/m/Y', strtotime($p['tanggal_pesan'])) ?></td>
                <td><?= date('d/m/Y', strtotime($p['tanggal_masuk'])) ?></td>
                <td><?= date('d/m/Y', strtotime($p['tanggal_keluar'])) ?></td>
                <td style="vertical-align:top;">
<?php
$status = strtolower($p['status']);
if($status == 'lunas') {
    echo '<span class="badge-status badge-sukses">Lunas</span>';
} elseif($status == 'pending') {
    echo '<span class="badge-status badge-pending">Pending</span>';
} else {
    echo '<span class="badge-status badge-batal">Ditolak</span>';
}
?>
</td>
                <td style="vertical-align:top;">
    <div style="display:flex;gap:10px;align-items:center;">
        <a href="detail_pemesanan.php?id=<?= $p['id'] ?>" class="btn-detail">Detail</a>
        <?php if(strtolower($p['status']) == 'pending' && $batasBayar > $now): ?>
            <a href="pembayaran.php?id=<?= $p['id'] ?>" class="btn-detail" style="background:#28a745;color:#fff;">Bayar</a>
            <?php
            // Cek apakah user sudah membayar pesanan ini
            $qBayar = mysqli_query($conn, "SELECT 1 FROM pembayaran WHERE id_user=$userId AND id_pemesanan=".$p['id']);
            $sudahBayar = mysqli_num_rows($qBayar) > 0;
            if(!$sudahBayar): ?>
                <a href="riwayat_pemesanan.php?batal=<?= $p['id'] ?>" class="btn-detail" style="background:#d60000;color:#fff;">Batalkan Pesanan</a>
            <?php endif; ?>
        <?php endif; ?>
        <?php if(strtolower($p['status']) == 'lunas'): ?>
            <a href="perpanjang_sewa.php?id=<?= $p['id'] ?>" class="btn-detail" style="background:#ff9800;color:#fff;">Perpanjang Sewa</a>
        <?php endif; ?>
    </div>
</td>
            </tr>
        <?php endforeach; endif; ?>
        </tbody>
    </table>
</div>
<footer class="footer-dark">
  <div class="footer-dark-main" style="display:flex;justify-content:space-between;align-items:flex-start;gap:40px;">
    <div class="footer-dark-col brand" style="flex:1;min-width:200px;">
      <div class="footer-dark-logo">AngMansion</div>
      <div class="footer-dark-desc">Kos modern, nyaman, dan strategis untuk kebutuhan hunian Anda.</div>
    </div>
    <div class="footer-dark-col social" style="flex:1;min-width:200px;display:flex;flex-direction:column;align-items:flex-end;">
      <div class="footer-dark-title">FOLLOW US</div>
      <div class="footer-dark-social" style="display:flex;gap:18px;justify-content:flex-end;">
        <a href="#" title="Instagram"><svg width="22" height="22" fill="currentColor"><use xlink:href="#icon-ig"/></svg></a>
        <a href="#" title="Facebook"><svg width="22" height="22" fill="currentColor"><use xlink:href="#icon-fb"/></svg></a>
        <a href="#" title="Twitter"><svg width="22" height="22" fill="currentColor"><use xlink:href="#icon-tw"/></svg></a>
      </div>
    </div>
  </div>
  <div class="footer-dark-bottom">
    <div class="footer-dark-copyright">&copy; 2025 Ang Mansion. All Rights Reserved</div>
    <div class="footer-dark-links">
      <a href="#">PRIVACY POLICY</a>
      <a href="#">TERMS AND CONDITIONS</a>
    </div>
  </div>
  <!-- SVG ICONS -->
  <svg style="display:none;">
    <symbol id="icon-fb" viewBox="0 0 16 16"><path d="M8.94 8.5H10.5V16H7.5V8.5H6V6.5h1.5V5.5c0-1.104.896-2 2-2h1.5v2H10.5c-.276 0-.5.224-.5.5v1h2l-.5 2H10.5V16H8.94V8.5z"/></symbol>
    <symbol id="icon-tw" viewBox="0 0 16 16"><path d="M16 3.039a6.461 6.461 0 0 1-1.885.516A3.301 3.301 0 0 0 15.555 1.8a6.533 6.533 0 0 1-2.084.797A3.286 3.286 0 0 0 7.88 4.03c0 .258.03.51.085.75A9.325 9.325 0 0 1 1.112 2.1a3.284 3.284 0 0 0 1.018 4.381A3.323 3.323 0 0 1 .64 6.575v.041a3.288 3.288 0 0 0 2.632 3.218c-.23.062-.473.096-.724.096-.177 0-.348-.017-.516-.049a3.293 3.293 0 0 0 3.067 2.281A6.588 6.588 0 0 1 .78 13.58a6.32 6.32 0 0 1-.78-.045A9.344 9.344 0 0 0 5.026 15c6.038 0 9.341-5.003 9.341-9.334 0-.142-.004-.284-.01-.425A6.673 6.673 0 0 0 16 3.039z"/></symbol>
    <symbol id="icon-ig" viewBox="0 0 16 16"><path d="M8 3a5 5 0 1 0 0 10A5 5 0 0 0 8 3zm0 8.5A3.5 3.5 0 1 1 8 4.5a3.5 3.5 0 0 1 0 7zm5-8.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zm-1 0v10a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1z"/></symbol>
  </svg>
</footer>
<?php
// Proses pembatalan pesanan
if(isset($_GET['batal'])) {
    $idBatal = intval($_GET['batal']);
    // Hanya boleh membatalkan pesanan milik sendiri yang masih pending dan belum dibayar
    $cek = mysqli_query($conn, "SELECT * FROM pemesanan WHERE id=$idBatal AND id_user=$userId AND status='pending'");
    if(mysqli_num_rows($cek) > 0) {
        // Hapus pesanan
        mysqli_query($conn, "DELETE FROM pemesanan WHERE id=$idBatal");
        // (Opsional) update status kamar ke 'tersedia'
        $row = mysqli_fetch_assoc($cek);
        mysqli_query($conn, "UPDATE kamar SET status='tersedia' WHERE id=".$row['id_kamar']);
        echo '<div class="alert-success" style="margin:20px auto;max-width:700px;">Pesanan berhasil dibatalkan.</div>';
    }
}
?>
</body>
</html> 