<?php
date_default_timezone_set('Asia/Jakarta');
session_start();
include '../config/koneksi.php';
$isLogin = isset($_SESSION['user_id']);
$user = null;
$userNama = '';
if($isLogin){
    $userId = $_SESSION['user_id'];
    $userNama = $_SESSION['user_nama'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}
$userId = $_SESSION['user_id'];
$kamarId = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Ambil data kamar
$kamar = null;
if ($kamarId > 0) {
    $q = mysqli_query($conn, "SELECT * FROM kamar WHERE id=$kamarId");
    $kamar = mysqli_fetch_assoc($q);
}
if (!$kamar) {
    echo '<h2>Kamar tidak ditemukan.</h2>';
    exit;
}

// Cek/alter kolom catatan jika belum ada
$catatan_col = mysqli_query($conn, "SHOW COLUMNS FROM pemesanan LIKE 'catatan'");
if (mysqli_num_rows($catatan_col) == 0) {
    mysqli_query($conn, "ALTER TABLE pemesanan ADD COLUMN catatan TEXT");
}

$success = false;
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tanggal_masuk = mysqli_real_escape_string($conn, $_POST['tanggal_masuk']);
    $lama_sewa = isset($_POST['lama_sewa']) ? (int)$_POST['lama_sewa'] : 1;
    // Hitung tanggal_keluar otomatis
    $tanggal_keluar = date('Y-m-d', strtotime("$tanggal_masuk +$lama_sewa month"));
    $catatan = mysqli_real_escape_string($conn, $_POST['catatan']);
    // Hapus variabel bank, no_rekening, nama_pemilik, jumlah, bukti
    // Tambahkan batas waktu pembayaran (2 jam dari sekarang)
    $batas_bayar = date('Y-m-d H:i:s', strtotime('+2 hours'));
    // Simpan ke tabel pemesanan
    $sql = "INSERT INTO pemesanan (id_user, id_kamar, tanggal_pesan, tanggal_masuk, tanggal_keluar, status, catatan, batas_bayar) VALUES ($userId, $kamarId, CURDATE(), '$tanggal_masuk', '$tanggal_keluar', 'pending', '$catatan', '$batas_bayar')";
    if (mysqli_query($conn, $sql)) {
        // Tidak perlu insert ke pembayaran di sini
        // Update status kamar
        mysqli_query($conn, "UPDATE kamar SET status='terisi' WHERE id=$kamarId");
        $success = true;
    } else {
        $error = 'Gagal menyimpan reservasi. Silakan coba lagi.';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reservasi Kamar - AngMansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { background: #f4f8ff; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .container { max-width: 600px; margin: 40px auto; background: #fff; border-radius: 18px; box-shadow: 0 4px 20px rgba(30,42,120,0.08); padding: 32px; }
        .form-title { font-size: 2em; font-weight: 800; color: #1e2a78; margin-bottom: 18px; }
        .form-group { margin-bottom: 18px; }
        label { font-weight: 700; color: #3a5eff; margin-bottom: 6px; display: block; }
        input, textarea { width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #c3e6cb; font-size: 1em; }
        input[type="file"] { border: none; }
        .btn-submit { background: linear-gradient(45deg, #3a5eff, #6ea0ff); color: #fff; border: none; border-radius: 10px; padding: 12px 24px; font-weight: 700; font-size: 1.1em; margin-top: 10px; cursor: pointer; }
        .btn-submit:hover { background: linear-gradient(45deg, #1e2a78, #3a5eff); }
        .alert-success { background: #d4edda; color: #155724; padding: 12px; border-radius: 8px; margin-bottom: 18px; }
        .alert-error { background: #f8d7da; color: #721c24; padding: 12px; border-radius: 8px; margin-bottom: 18px; }
        .kamar-info { background: #f1f7ff; border-radius: 10px; padding: 16px; margin-bottom: 24px; }
        .kamar-info strong { color: #1e2a78; }
    </style>
</head>
<body>
    <div class="navbar" style="display:flex;align-items:center;justify-content:space-between;background:#7daaff;padding:0 32px;height:64px;">
    <div style="display:flex;align-items:center;gap:16px;">
        <img src="../assets/images/LogoAngMansion-Putih.png" alt="Logo" style="height:40px;">
        <span style="font-size:2em;font-weight:700;color:#fff;letter-spacing:1px;">AngMansion</span>
    </div>
    <div style="display:flex;align-items:center;gap:32px;">
        <a href="index.php" class="<?= basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : '' ?>">Beranda</a>
        <a href="kamar.php" class="<?= basename($_SERVER['PHP_SELF']) == 'kamar.php' ? 'active' : '' ?>">Kamar</a>
        <a href="layanan_request.php" class="<?= basename($_SERVER['PHP_SELF']) == 'layanan_request.php' ? 'active' : '' ?>">Layanan</a>
        <a href="kontak.php" class="<?= basename($_SERVER['PHP_SELF']) == 'kontak.php' ? 'active' : '' ?>">Hubungi Kami</a>
        <a href="riwayat_pemesanan.php" class="<?= basename($_SERVER['PHP_SELF']) == 'riwayat_pemesanan.php' ? 'active' : '' ?>">Riwayat Pemesanan</a>
    </div>
    <?php if($isLogin): ?>
    <div style="display:flex;align-items:center;gap:16px;">
        <img src="../assets/images/profile/<?= htmlspecialchars($user['foto'] ?? 'user_2.png') ?>" alt="Profil" style="height:44px;width:44px;border-radius:50%;border:2px solid #3a5eff;background:#fff;object-fit:cover;">
        <span style="font-weight:700;color:#fff;font-size:1.2em;"><?= htmlspecialchars($user['nama'] ?? 'User') ?></span>
        <a href="profile.php" style="background:#fff;color:#1e2a78;font-weight:700;padding:6px 18px;border-radius:8px;text-decoration:none;">Profil</a>
        <a href="logout.php" style="background:#d60000;color:#fff;font-weight:700;padding:6px 18px;border-radius:8px;text-decoration:none;">Keluar</a>
    </div>
    <?php endif; ?>
</div>
    <div class="container">
        <div class="form-title">Reservasi Kamar</div>
        <?php if($success): ?>
            <div class="alert-success">
                Reservasi berhasil! silahkan lakukan pembayaran dihalaman riwayat pemesanan.<br>
                <b>Pembayaran maksimal sampai: <?= date('d-m-Y H:i', strtotime($batas_bayar)) ?></b>
            </div>
            
        <?php else: ?>
            <?php if($error): ?><div class="alert-error"><?= $error ?></div><?php endif; ?>
            <div class="kamar-info">
                <strong>Kamar:</strong> <?= htmlspecialchars($kamar['tipe'] ?? $kamar['nama']) ?><br>
                <strong>Harga:</strong> Rp<?= number_format($kamar['harga'],0,',','.') ?> / bulan
            </div>
            <form method="post">
                <div class="form-group">
                    <label for="lama_sewa" style="font-weight:700;color:#3a5eff;font-size:1.2em;">Lama Sewa</label>
                    <select name="lama_sewa" id="lama_sewa" required style="width:100%;padding:10px 14px;border-radius:8px;border:1px solid #b6e2c6;font-size:1.1em;margin-bottom:18px;">
                        <option value="">Pilih lama sewa</option>
                        <?php for($i=1;$i<=12;$i++): ?>
                            <option value="<?= $i ?>"><?= $i ?> bulan</option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="tanggal_masuk" style="font-weight:700;color:#3a5eff;font-size:1.2em;">Tanggal Masuk</label>
                    <input type="date" name="tanggal_masuk" id="tanggal_masuk" required style="width:100%;padding:10px 14px;border-radius:8px;border:1px solid #b6e2c6;font-size:1.1em;margin-bottom:18px;">
                </div>
                <div class="form-group">
                    <label for="catatan">Catatan (opsional)</label>
                    <textarea name="catatan" id="catatan" rows="3"></textarea>
                </div>
                <button type="submit" class="btn-submit">Kirim Reservasi</button>
            </form>
        <?php endif; ?>
    </div>
    <script>
document.getElementById('bank').addEventListener('change', function() {
    var norek = '';
    if(this.value) norek = '123******';
    document.getElementById('no_rekening').value = norek;
});
</script>
</body>
</html> 