<?php
session_start();
include '../config/koneksi.php';
$user = null;
$userNama = '';
$isLogin = isset($_SESSION['user_id']);
if($isLogin){
    $userId = $_SESSION['user_id'];
    $userNama = $_SESSION['user_nama'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}
$activePage = '';
include 'header.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
$userId = $_SESSION['user_id'];
$pemesananId = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Ambil data pemesanan lama
$pemesanan = null;
if ($pemesananId > 0) {
    $q = mysqli_query($conn, "SELECT p.*, k.tipe, k.harga, k.gambar FROM pemesanan p JOIN kamar k ON p.id_kamar = k.id WHERE p.id = $pemesananId AND p.id_user = $userId");
    $pemesanan = mysqli_fetch_assoc($q);
}
if (!$pemesanan) {
    echo '<h2>Data pemesanan tidak ditemukan.</h2>';
    exit;
}

$success = false;
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $lama_sewa = isset($_POST['lama_sewa']) ? (int)$_POST['lama_sewa'] : 1;
    $tanggal_masuk = $pemesanan['tanggal_keluar'];
    $tanggal_keluar = date('Y-m-d', strtotime("$tanggal_masuk +$lama_sewa month"));
    $catatan = mysqli_real_escape_string($conn, $_POST['catatan']);
    $batas_bayar = date('Y-m-d H:i:s', strtotime('+1 day'));
    $id_kamar = $pemesanan['id_kamar'];
    // Insert pemesanan baru
    $sql = "INSERT INTO pemesanan (id_user, id_kamar, tanggal_pesan, batas_bayar, tanggal_masuk, tanggal_keluar, status, catatan) VALUES ($userId, $id_kamar, CURDATE(), '$batas_bayar', '$tanggal_masuk', '$tanggal_keluar', 'pending', '$catatan')";
    if (mysqli_query($conn, $sql)) {
        $newId = mysqli_insert_id($conn);
        header('Location: pembayaran.php?id=' . $newId);
        exit;
    } else {
        $error = 'Gagal memperpanjang sewa. Silakan coba lagi.<br>SQL: ' . htmlspecialchars($sql) . '<br>Error: ' . mysqli_error($conn);
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perpanjang Sewa - AngMansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { background: #f4f8ff; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .container { max-width: 600px; margin: 40px auto; background: #fff; border-radius: 18px; box-shadow: 0 4px 20px rgba(30,42,120,0.08); padding: 32px; }
        .form-title { font-size: 2em; font-weight: 800; color: #1e2a78; margin-bottom: 18px; }
        .form-group { margin-bottom: 18px; }
        label { font-weight: 700; color: #3a5eff; margin-bottom: 6px; display: block; }
        input, textarea { width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #c3e6cb; font-size: 1em; }
        .btn-submit { background: linear-gradient(45deg, #ff9800, #ffb74d); color: #fff; border: none; border-radius: 10px; padding: 12px 24px; font-weight: 700; font-size: 1.1em; margin-top: 10px; cursor: pointer; }
        .btn-submit:hover { background: linear-gradient(45deg, #ff9800, #ff9800); }
        .alert-success { background: #d4edda; color: #155724; padding: 12px; border-radius: 8px; margin-bottom: 18px; }
        .alert-error { background: #f8d7da; color: #721c24; padding: 12px; border-radius: 8px; margin-bottom: 18px; }
        .kamar-info { background: #f1f7ff; border-radius: 10px; padding: 16px; margin-bottom: 24px; }
        .kamar-info strong { color: #1e2a78; }
    </style>
</head>
<body>
    <div class="container">
        <div class="form-title">Perpanjang Sewa Kamar</div>
        <?php if($error): ?><div class="alert-error"><?= $error ?></div><?php endif; ?>
        <div class="kamar-info">
            <strong>Kamar:</strong> <?= htmlspecialchars($pemesanan['tipe']) ?><br>
            <strong>Harga:</strong> Rp<?= number_format($pemesanan['harga'],0,',','.') ?> / bulan<br>
            <strong>Tanggal Masuk Baru:</strong> <?= date('d/m/Y', strtotime($pemesanan['tanggal_keluar'])) ?><br>
        </div>
        <form method="post">
            <div class="form-group">
                <label for="lama_sewa" style="font-weight:700;color:#3a5eff;font-size:1.2em;">Lama Sewa</label>
                <select name="lama_sewa" id="lama_sewa" required style="width:100%;padding:10px 14px;border-radius:8px;border:1px solid #b6e2c6;font-size:1.1em;margin-bottom:18px;">
                    <option value="">Pilih lama sewa</option>
                    <?php for($i=1;$i<=12;$i++): ?>
                        <option value="<?= $i ?>"><?= $i ?> bulan</option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="catatan">Catatan (opsional)</label>
                <textarea name="catatan" id="catatan" rows="3"></textarea>
            </div>
            <button type="submit" class="btn-submit">Perpanjang Sewa</button>
        </form>
    </div>
</body>
</html> 