<?php
date_default_timezone_set('Asia/Jakarta');
session_start();
include '../config/koneksi.php';
$user = null;
$userNama = '';
$isLogin = isset($_SESSION['user_id']);
if($isLogin){
    $userId = $_SESSION['user_id'];
    $userNama = $_SESSION['user_nama'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}
$activePage = '';
include 'header.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
// Cek pesanan
$q = mysqli_query($conn, "SELECT * FROM pemesanan WHERE id=$id AND id_user=$userId");
$pemesanan = mysqli_fetch_assoc($q);
// Cek apakah sudah pernah membayar
$qBayar = mysqli_query($conn, "SELECT * FROM pembayaran WHERE id_user=$userId AND id_pemesanan=$id");
$sudahBayar = mysqli_num_rows($qBayar) > 0;
if (!$pemesanan || strtolower($pemesanan['status']) != 'pending') {
    echo "<h2>Data pesanan tidak ditemukan atau sudah tidak bisa dibayar.</h2>";
    exit;
}
$success = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bank = mysqli_real_escape_string($conn, $_POST['bank']);
    $no_rekening = mysqli_real_escape_string($conn, $_POST['no_rekening']);
    $nama_pemilik = mysqli_real_escape_string($conn, $_POST['nama_pemilik']);
    $jumlah = (int)$_POST['jumlah'];
    $bukti = '';
    if (isset($_FILES['bukti']) && $_FILES['bukti']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['bukti']['name'], PATHINFO_EXTENSION);
        $bukti = 'bukti_' . time() . '_' . rand(1000,9999) . '.' . $ext;
        move_uploaded_file($_FILES['bukti']['tmp_name'], '../assets/images/' . $bukti);
    }
    $sql_bayar = "INSERT INTO pembayaran (id_user, id_pemesanan, nama, jumlah, bank, no_rekening, nama_pemilik, bukti, tanggal_bayar) VALUES ($userId, $id, '', $jumlah, '$bank', '$no_rekening', '$nama_pemilik', '$bukti', CURDATE())";
    mysqli_query($conn, $sql_bayar);
    $success = true;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pembayaran Pesanan - AngMansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { background: #f4f8ff; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .container { max-width: 600px; margin: 40px auto; background: #fff; border-radius: 18px; box-shadow: 0 4px 20px rgba(30,42,120,0.08); padding: 32px; }
        .form-title { font-size: 2em; font-weight: 800; color: #1e2a78; margin-bottom: 18px; }
        .form-group { margin-bottom: 18px; }
        label { font-weight: 700; color: #3a5eff; margin-bottom: 6px; display: block; }
        input, textarea { width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #c3e6cb; font-size: 1em; }
        input[type="file"] { border: none; }
        .btn-submit { background: linear-gradient(45deg, #3a5eff, #6ea0ff); color: #fff; border: none; border-radius: 10px; padding: 12px 24px; font-weight: 700; font-size: 1.1em; margin-top: 10px; cursor: pointer; }
        .btn-submit:hover { background: linear-gradient(45deg, #1e2a78, #3a5eff); }
        .alert-success { background: #d4edda; color: #155724; padding: 12px; border-radius: 8px; margin-bottom: 18px; }
        .timer-box { font-size:1.1em; color:#c00; font-weight:600; margin-bottom:18px; }
    </style>
</head>
<body>
<div class="container">
    <div class="form-title">Pembayaran Pesanan</div>
    <?php if($sudahBayar): ?>
        <div class="alert-success">Anda sudah melakukan pembayaran untuk pesanan ini. Silakan tunggu verifikasi admin.</div>
        <a href="riwayat_pemesanan.php" class="btn-submit">Kembali ke Riwayat</a>
    <?php elseif($success): ?>
        <div class="alert-success">Bukti pembayaran berhasil diupload! Menunggu verifikasi admin.</div>
        <a href="riwayat_pemesanan.php" class="btn-submit">Kembali ke Riwayat</a>
    <?php else: ?>
    <?php
    $batasBayar = strtotime($pemesanan['batas_bayar']);
    $now = time();
    ?>
    <div id="timer" class="timer-box"></div>
    <div style="margin-bottom:18px;">
        <div style="font-weight:700;color:#3a5eff;font-size:1.1em;margin-bottom:8px;">Nomor Rekening Pembayaran</div>
        <div style="display:flex;flex-wrap:wrap;gap:18px;align-items:center;">
            <div style="display:flex;align-items:center;gap:10px;background:#f4f8ff;padding:8px 18px;border-radius:8px;min-width:220px;">
                <img src="../assets/images/LogoBCA.jpg" alt="BCA" style="height:28px;width:28px;object-fit:contain;"> BCA: <span style="font-family:monospace;font-size:1.1em;">1234567890</span>
            </div>
            <div style="display:flex;align-items:center;gap:10px;background:#f4f8ff;padding:8px 18px;border-radius:8px;min-width:220px;">
                <img src="../assets/images/LogoBRI.jpg" alt="BRI" style="height:28px;width:28px;object-fit:contain;"> BRI: <span style="font-family:monospace;font-size:1.1em;">1234567890</span>
            </div>
            <div style="display:flex;align-items:center;gap:10px;background:#f4f8ff;padding:8px 18px;border-radius:8px;min-width:220px;">
                <img src="../assets/images/LogoBNI.jpg" alt="BNI" style="height:28px;width:28px;object-fit:contain;"> BNI: <span style="font-family:monospace;font-size:1.1em;">1234567890</span>
            </div>
            <div style="display:flex;align-items:center;gap:10px;background:#f4f8ff;padding:8px 18px;border-radius:8px;min-width:220px;">
                <img src="../assets/images/LogoMANDIRI.jpg" alt="Mandiri" style="height:28px;width:28px;object-fit:contain;"> Mandiri: <span style="font-family:monospace;font-size:1.1em;">1234567890</span>
            </div>
        </div>
    </div>
    <script>
    var countDownDate = new Date('<?= date('Y-m-d H:i:s', $batasBayar) ?>').getTime();
    var form = null;
    document.addEventListener('DOMContentLoaded', function() {
        form = document.getElementById('form-bayar');
    });
    var x = setInterval(function() {
        var now = new Date().getTime();
        var distance = countDownDate - now;
        if (distance < 0) {
            clearInterval(x);
            document.getElementById('timer').innerHTML = 'Waktu pembayaran habis!';
            if(form) form.style.display = 'none';
        } else {
            var m = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var s = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById('timer').innerHTML = 'Sisa waktu pembayaran: ' + m + ' menit ' + s + ' detik';
        }
    }, 1000);
    </script>
    <form method="post" enctype="multipart/form-data" id="form-bayar">
        <div class="form-group">
            <label for="bank">Bank</label>
            <select name="bank" id="bank" required>
                <option value="">-- Pilih Bank --</option>
                <option value="BCA">BCA</option>
                <option value="BRI">BRI</option>
                <option value="BNI">BNI</option>
                <option value="Mandiri">Mandiri</option>
            </select>
        </div>
        <div class="form-group">
            <label for="no_rekening">Nomer Rekening Anda</label>
            <input type="text" name="no_rekening" id="no_rekening" required>
        </div>
        <div class="form-group">
            <label for="nama_pemilik">Nama Pemilik Rekening</label>
            <input type="text" name="nama_pemilik" id="nama_pemilik" required>
        </div>
        <div class="form-group">
            <label for="jumlah">Jumlah Pembayaran</label>
            <input type="number" name="jumlah" id="jumlah" min="1" required>
        </div>
        <div class="form-group">
            <label for="bukti">Upload Bukti Pembayaran</label>
            <input type="file" name="bukti" id="bukti" accept="image/*" required>
        </div>
        <button type="submit" class="btn-submit">Upload Bukti Pembayaran</button>
    </form>
    <?php endif; ?>
</div>
</body>
</html> 