<?php
session_start();
include '../config/koneksi.php';
$isLogin = isset($_SESSION['user_id']);
$user = null;
$userNama = '';
if($isLogin){
    $userId = $_SESSION['user_id'];
    $userNama = $_SESSION['user_nama'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}
$activePage = 'layanan';
include 'header.php';
// Proses submit form
if(isset($_POST['submit_request'])){
    $jenis = mysqli_real_escape_string($conn, $_POST['jenis_layanan']);
    $deskripsi = mysqli_real_escape_string($conn, $_POST['deskripsi']);
    $foto = '';
    if(isset($_FILES['foto']) && $_FILES['foto']['error'] == 0){
        $ext = strtolower(pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','gif'];
        if(in_array($ext, $allowed)){
            $namafile = 'req_'.time().'_'.rand(1000,9999).'.'.$ext;
            $target = '../assets/images/'.$namafile;
            if(move_uploaded_file($_FILES['foto']['tmp_name'], $target)){
                $foto = $namafile;
            }
        }
    }
    mysqli_query($conn, "INSERT INTO layanan_request (user_id, jenis_layanan, deskripsi, foto) VALUES ($userId, '$jenis', '$deskripsi', '$foto')");
    echo '<div class="alert" style="background:#d4edda;color:#155724;">Request layanan berhasil dikirim!</div>';
}
$riwayat = mysqli_query($conn, "SELECT * FROM layanan_request WHERE user_id=$userId ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Layanan - Ang Mansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { background: #8f82ff; }
        .hero { font-size:2em; background: linear-gradient(90deg,rgba(30,42,120,0.7),rgba(30,42,120,0.3)), url('../assets/images/angMansion.jpg') center/cover no-repeat; min-height: 180px; display: flex; flex-direction: column; justify-content: center; align-items: center; margin-bottom: 0; }
        .hero span { color:#ffe600;font-weight:700;font-size:1.5em; margin-top: 32px; }
        .request-form-card { max-width: 420px; margin: 32px auto 24px auto; background: #fff; border-radius: 16px; box-shadow: 0 4px 24px rgba(37,99,235,0.10); padding: 32px 28px 24px 28px; }
        .request-title { color: #2563eb; font-size: 1.5em; font-weight: 700; margin-bottom: 24px; text-align: center; letter-spacing: 1px; }
        .request-form label { display: block; font-weight: 600; margin-bottom: 6px; color: #222; }
        .request-form input[type="text"], .request-form select, .request-form textarea, .request-form input[type="file"] { width: 100%; padding: 10px 12px; border: 1.5px solid #e0e7ef; border-radius: 8px; margin-bottom: 18px; font-size: 1em; transition: border 0.2s; font-family: inherit; background: #f8fafc; }
        .request-form input:focus, .request-form select:focus, .request-form textarea:focus { border: 1.5px solid #2563eb; outline: none; background: #fff; }
        .request-form button { width: 100%; background: #2563eb; color: #fff; border: none; border-radius: 8px; padding: 12px 0; font-size: 1.1em; font-weight: 700; cursor: pointer; transition: background 0.2s; margin-top: 8px; }
        .request-form button:hover { background: #1746a0; }
        .request-history-card { max-width: 900px; margin: 32px auto 24px auto; background: #fff; border-radius: 20px; box-shadow: 0 4px 24px rgba(37,99,235,0.10); padding: 36px 32px 28px 32px; }
        .request-history-title { color: #2563eb; font-size: 1.6em; font-weight: 700; margin-bottom: 28px; text-align: left; letter-spacing: 1px; }
        .request-table-wrap { overflow-x: auto; }
        .request-table { width: 100%; border-collapse: separate; border-spacing: 0; margin-top: 0; background: #fff; }
        .request-table th, .request-table td { border: 1px solid #e0e7ef; padding: 12px 14px; text-align: left; }
        .request-table th { background: #2563eb; color: #fff; font-size: 1.08em; }
        .request-table tr:nth-child(even) { background: #f4f8ff; }
        .request-table tr:nth-child(odd) { background: #fff; }
        .request-table th:first-child { border-top-left-radius: 12px; }
        .request-table th:last-child { border-top-right-radius: 12px; }
        .request-table tr:last-child td:first-child { border-bottom-left-radius: 12px; }
        .request-table tr:last-child td:last-child { border-bottom-right-radius: 12px; }
        .request-table td.status-menunggu { color: #f59e0b; font-weight: 600; }
        .request-table td.status-diproses { color: #2563eb; font-weight: 600; }
        .request-table td.status-selesai { color: #22c55e; font-weight: 600; }
        .request-table td.status-ditolak { color: #ef4444; font-weight: 600; }
        .request-table a { color: #2563eb; text-decoration: underline; font-weight: 600; transition: color 0.2s; }
        .request-table a:hover { color: #1746a0; }
        @media (max-width: 700px) {
            .request-history-card { padding: 18px 4px; }
            .request-table th, .request-table td { padding: 8px 6px; font-size: 0.98em; }
        }
    </style>
</head>
<body>
<div class="hero">
    <span>&gt;&gt;Layanan</span>
</div>
<div class="request-form-card">
    <div class="request-title">Request Layanan / Bantuan</div>
    <form method="post" enctype="multipart/form-data" class="request-form">
        <label for="jenis_layanan">Jenis Layanan</label>
        <select name="jenis_layanan" id="jenis_layanan" required>
            <option value="">-- Pilih Jenis --</option>
            <option value="Perbaikan Kamar">Perbaikan Kamar</option>
            <option value="Keluhan Fasilitas">Keluhan Fasilitas</option>
            <option value="Permintaan Bantuan">Permintaan Bantuan</option>
            <option value="Lainnya">Lainnya</option>
        </select>
        <label for="deskripsi">Deskripsi Permintaan</label>
        <textarea name="deskripsi" id="deskripsi" rows="3" required></textarea>
        <label for="foto">Foto (opsional)</label>
        <input type="file" name="foto" accept="image/*">
        <button type="submit" name="submit_request">Kirim Request</button>
    </form>
</div>
<div class="request-history-card">
    <div class="request-history-title">Riwayat Request Layanan Anda</div>
    <div class="request-table-wrap">
    <table class="request-table">
        <tr>
            <th>Tanggal</th>
            <th>Jenis</th>
            <th>Deskripsi</th>
            <th>Status</th>
            <th>Balasan Admin</th>
            <th>Foto</th>
        </tr>
        <?php while($r = mysqli_fetch_assoc($riwayat)): ?>
        <tr>
            <td><?php echo date('d-m-Y H:i', strtotime($r['created_at'])); ?></td>
            <td><?php echo htmlspecialchars($r['jenis_layanan']); ?></td>
            <td><?php echo nl2br(htmlspecialchars($r['deskripsi'])); ?></td>
            <td class="status-<?php echo strtolower($r['status']); ?>"><?php echo htmlspecialchars($r['status']); ?></td>
            <td><?php echo $r['balasan_admin'] ? nl2br(htmlspecialchars($r['balasan_admin'])) : '-'; ?></td>
            <td><?php if($r['foto']): ?><a href="../assets/images/<?php echo htmlspecialchars($r['foto']); ?>" target="_blank">Lihat</a><?php else: ?>-<?php endif; ?></td>
        </tr>
        <?php endwhile; ?>
    </table>
    </div>
</div>
</body>
</html> 