<?php
session_start();
include '../config/koneksi.php';

// Ambil ID kamar dari URL
$kamarId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$kamar = null;
if ($kamarId > 0) {
    $q = mysqli_query($conn, "SELECT * FROM kamar WHERE id=$kamarId");
    $kamar = mysqli_fetch_assoc($q);
}

if (!$kamar) {
    echo '<h2>Kamar tidak ditemukan.</h2>';
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Kamar - AngMansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { background: #f4f8ff; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .container { max-width: 700px; margin: 40px auto; background: #fff; border-radius: 18px; box-shadow: 0 4px 20px rgba(30,42,120,0.08); padding: 32px; }
        .kamar-img { width: 100%; max-height: 340px; object-fit: cover; border-radius: 12px; margin-bottom: 24px; }
        .kamar-title { font-size: 2.2em; font-weight: 800; color: #1e2a78; margin-bottom: 10px; }
        .kamar-harga { font-size: 1.4em; font-weight: 700; color: #3a5eff; margin-bottom: 12px; }
        .badge-status { font-size: 1em; font-weight: 600; border-radius: 20px; padding: 6px 16px; display: inline-block; margin-bottom: 12px; }
        .badge-tersedia { background: linear-gradient(45deg, #e6f9ed, #d4edda); color: #1e7e34; border: 1px solid #c3e6cb; }
        .badge-dipesan { background: linear-gradient(45deg, #ffeaea, #f8d7da); color: #721c24; border: 1px solid #f5c6cb; }
        .badge-promo { background: linear-gradient(45deg, #28a745, #20c997); color: #fff; font-weight: 700; font-size: 0.95em; border-radius: 20px; padding: 6px 16px; margin-left: 10px; }
        .kamar-desc { font-size: 1.1em; color: #333; margin-bottom: 24px; }
        .btn-back { display: inline-block; margin-top: 18px; background: #3a5eff; color: #fff; padding: 10px 22px; border-radius: 10px; text-decoration: none; font-weight: 700; transition: background 0.2s; }
        .btn-back:hover { background: #1e2a78; }
        .btn-pesan { background: linear-gradient(45deg, #3a5eff, #6ea0ff); color: #fff; border: none; border-radius: 10px; padding: 12px 24px; font-weight: 700; font-size: 1.1em; text-decoration: none; margin-left: 12px; }
        .btn-pesan:hover { background: linear-gradient(45deg, #1e2a78, #3a5eff); }
    </style>
</head>
<body>
    <div class="container">
        <img class="kamar-img" src="../assets/images/<?= $kamar['gambar'] ? htmlspecialchars($kamar['gambar']) : 'angMansion.jpg' ?>" alt="Foto Kamar <?= htmlspecialchars($kamar['tipe'] ?? $kamar['nama_kamar']) ?>" onerror="this.src='../assets/images/angMansion.jpg'">
        <div class="kamar-title">
            <?= htmlspecialchars($kamar['tipe'] ?? $kamar['nama_kamar']) ?>
            <?php if(isset($kamar['promo']) && $kamar['promo'] == 1): ?>
                <span class="badge-promo">PROMO!</span>
            <?php endif; ?>
        </div>
        <div class="kamar-harga">Rp<?= number_format($kamar['harga'],0,',','.') ?> <span style="font-size:0.8em;font-weight:400;color:#6c757d;">/ bulan</span></div>
        <div class="fasilitas-list" style="display:flex;gap:14px;margin:12px 0 18px 0;flex-wrap:wrap;">
    <span title="WiFi" style="display:flex;align-items:center;gap:4px;font-size:1.1em;"><span style="font-size:1.2em;">📶</span>WiFi</span>
    <?php if(strtolower($kamar['tipe']) != 'superior'): ?>
    <span title="AC" style="display:flex;align-items:center;gap:4px;font-size:1.1em;"><span style="font-size:1.2em;">❄️</span>AC</span>
    <?php endif; ?>
    <span title="Kamar Mandi Dalam" style="display:flex;align-items:center;gap:4px;font-size:1.1em;"><span style="font-size:1.2em;">🚿</span>K. Mandi Dalam</span>
    <span title="Dapur Bersama" style="display:flex;align-items:center;gap:4px;font-size:1.1em;"><span style="font-size:1.2em;">🍳</span>Dapur</span>
    <span title="Parkir" style="display:flex;align-items:center;gap:4px;font-size:1.1em;"><span style="font-size:1.2em;">🅿️</span>Parkir</span>
</div>
        <div class="badge-status <?= ($kamar['status'] ?? '') === 'tersedia' ? 'badge-tersedia' : 'badge-dipesan' ?>">
            <?= ($kamar['status'] ?? '') === 'tersedia' ? '✓ Tersedia' : '✗ Sudah Dipesan' ?>
        </div>
        <div class="kamar-desc">
            <?php if(!empty($kamar['deskripsi'])): ?>
                <?= htmlspecialchars($kamar['deskripsi']) ?>
            <?php else: ?>
                Tidak ada deskripsi kamar.
            <?php endif; ?>
        </div>
        <?php if(strtolower($kamar['tipe']) == 'deluxe'): ?>
            <div style="font-size:1.08em;color:#1e2a78;margin-bottom:18px;font-weight:600;">Termasuk AC dan WaterHeater</div>
        <?php elseif(strtolower($kamar['tipe']) == 'superior'): ?>
            <div style="font-size:1.08em;color:#c00;margin-bottom:18px;font-weight:600;">Tidak mendapatkan fasilitas seperti AC dan WaterHeater</div>
        <?php endif; ?>
        <a href="kamar.php" class="btn-back">&larr; Kembali</a>
        <?php if(($kamar['status'] ?? '') === 'tersedia'): ?>
            <a href="reservasi.php?id=<?= $kamar['id'] ?>" class="btn-pesan">Pesan Sekarang</a>
        <?php endif; ?>
    </div>
</body>
</html> 