<?php
session_start();
include '../config/koneksi.php';
$isLogin = isset($_SESSION['user_id']);
$userNama = $isLogin ? $_SESSION['user_nama'] : '';
$user = null;
if($isLogin){
    $userId = $_SESSION['user_id'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}
$activePage = 'kamar';
include 'header.php';

// Ambil data kamar
$q = mysqli_query($conn, "SELECT * FROM kamar ORDER BY harga ASC");
$kamarList = [];
while($row = mysqli_fetch_assoc($q)) {
    $row['promo'] = isset($row['promo']) && $row['promo'] == '1';
    $kamarList[] = $row;
}

// Ambil stok kamar per tipe dan gambar representatif
$stokSuperior = 0;
$stokDeluxe = 0;
$gambarDefault = 'images/kamar1.jpg'; // default untuk kedua tipe
$gambarSuperior = $gambarDefault;
$gambarDeluxe = $gambarDefault;
$gambarKamarAngMansion = '../assets/KamarAngMansion.jpg';
foreach ($kamarList as $kamar) {
    if (strtolower($kamar['tipe']) == 'superior') {
        if ($kamar['status'] === 'tersedia') $stokSuperior++;
        if (!empty($kamar['gambar'])) $gambarSuperior = $kamar['gambar'];
    } elseif (strtolower($kamar['tipe']) == 'deluxe') {
        if ($kamar['status'] === 'tersedia') $stokDeluxe++;
        if (!empty($kamar['gambar'])) $gambarDeluxe = $kamar['gambar'];
    }
}
if (empty($gambarSuperior)) $gambarSuperior = $gambarDefault;
if (empty($gambarDeluxe)) $gambarDeluxe = $gambarDefault;

// Hitung stok tersedia per tipe
$stokDeluxe = 0;
$stokSuperior = 0;
foreach($kamarList as $kamar) {
    if (strtolower($kamar['tipe']) == 'deluxe' && $kamar['status'] === 'tersedia') $stokDeluxe++;
    if (strtolower($kamar['tipe']) == 'superior' && $kamar['status'] === 'tersedia') $stokSuperior++;
}

// Jika tidak ada data, tampilkan dummy data
if (empty($kamarList)) {
    $kamarList = [
        [
            'id' => 1,
            'tipe' => 'Kamar A1',
            'harga' => 1200000,
            'gambar' => 'images/kamar1.jpg',
            'status' => 'tersedia',
            'promo' => true
        ],
        [
            'id' => 2,
            'tipe' => 'Kamar A2',
            'harga' => 1500000,
            'gambar' => 'images/kamar2.jpg',
            'status' => 'sudah dipesan',
            'promo' => false
        ],
        [
            'id' => 3,
            'tipe' => 'Kamar A3',
            'harga' => 1200000,
            'gambar' => 'images/kamar3.jpg',
            'status' => 'tersedia',
            'promo' => true
        ],
    ];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kamar - AngMansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { 
            background: #f4f8ff; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-main { 
            background: linear-gradient(90deg,#6ea0ff 0%,#3a5eff 100%); 
            color: #fff; 
            box-shadow: 0 2px 8px rgba(0,0,0,0.08); 
        }
        
        .navbar-main .navbar-brand { 
            font-weight: 800; 
            font-size: 1.6em; 
            letter-spacing: 1px; 
        }
        
        .navbar-main .nav-link { 
            color: #fff !important; 
            font-weight: 700; 
            font-size: 1.1em; 
            margin-right: 18px; 
            transition: all 0.3s ease;
        }
        
        .navbar-main .nav-link.active, 
        .navbar-main .nav-link:focus, 
        .navbar-main .nav-link:hover { 
            background: #ff2d2d; 
            color: #fff !important; 
            border-radius: 8px; 
            transform: translateY(-2px);
        }
        
        .navbar-main .user-info { 
            color: #fff; 
            font-weight: 700; 
            margin-left: 18px; 
        }
        
        .navbar-main .avatar { 
            width: 32px; 
            height: 32px; 
            border-radius: 50%; 
            object-fit: cover; 
            margin-right: 6px; 
            border: 2px solid #fff; 
        }
        
        .hero-kamar-bg {
            background: linear-gradient(135deg, rgba(30,42,120,0.8), rgba(58,94,255,0.6)), 
                        url('../assets/images/angMansion.jpg') center/cover no-repeat;
            min-height: 300px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            position: relative;
            overflow: hidden;
        }
        
        .hero-kamar-bg::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, transparent 30%, rgba(255,230,0,0.1) 70%);
            animation: shimmer 3s infinite;
        }
        
        @keyframes shimmer {
            0%, 100% { opacity: 0.3; }
            50% { opacity: 0.7; }
        }
        
        .hero-kamar-title {
            color: #ffe600;
            font-size: 3.2rem;
            font-weight: 900;
            letter-spacing: 3px;
            text-align: center;
            margin-top: 0;
            text-shadow: 0 4px 20px rgba(0,0,0,0.5);
            animation: fadeInUp 1s ease-out;
            position: relative;
            z-index: 1;
        }
        
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .kamar-subtitle {
            color: #1e2a78;
            font-size: 2rem;
            font-weight: 700;
            text-align: center;
            margin: 48px 0 36px 0;
            position: relative;
        }
        
        .kamar-subtitle::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, #3a5eff, #6ea0ff);
            border-radius: 2px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .kamar-grid { 
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 32px;
            margin-bottom: 60px;
        }
        
        .card-kamar { 
            background: #fff; 
            border-radius: 20px; 
            box-shadow: 0 4px 20px rgba(30,42,120,0.08); 
            border: 2px solid #e0eaff; 
            transition: all 0.3s ease; 
            display: flex; 
            flex-direction: column; 
            overflow: hidden;
            position: relative;
        }
        
        .card-kamar:hover { 
            box-shadow: 0 12px 40px rgba(30,42,120,0.15); 
            border-color: #3a5eff; 
            transform: translateY(-5px);
        }
        
        .card-kamar .image-container {
            position: relative;
            overflow: hidden;
        }
        
        .card-kamar img { 
            width: 100%; 
            height: 200px; 
            object-fit: cover; 
            transition: transform 0.3s ease;
        }
        
        .card-kamar:hover img {
            transform: scale(1.05);
        }
        
        .badge-promo { 
            background: linear-gradient(45deg, #28a745, #20c997);
            color: #fff; 
            font-weight: 700; 
            font-size: 0.9em; 
            position: absolute; 
            top: 16px; 
            left: 16px; 
            border-radius: 20px; 
            padding: 6px 16px; 
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
            z-index: 2;
        }
        
        .badge-status { 
            font-size: 0.95em; 
            font-weight: 600; 
            border-radius: 20px; 
            padding: 6px 16px; 
            display: inline-block;
        }
        
        .badge-tersedia { 
            background: linear-gradient(45deg, #e6f9ed, #d4edda);
            color: #1e7e34; 
            border: 1px solid #c3e6cb;
        }
        
        .badge-dipesan { 
            background: linear-gradient(45deg, #ffeaea, #f8d7da);
            color: #721c24; 
            border: 1px solid #f5c6cb;
        }
        
        .kamar-nama { 
            font-size: 1.4em; 
            font-weight: 700; 
            color: #1e2a78; 
            margin-bottom: 8px; 
        }
        
        .kamar-harga { 
            font-size: 1.3em; 
            font-weight: 700; 
            color: #3a5eff; 
            margin-bottom: 12px; 
        }
        
        .kamar-harga .period {
            font-size: 0.85em;
            font-weight: 400;
            color: #6c757d;
        }
        
        .card-kamar .card-body { 
            padding: 24px; 
            display: flex; 
            flex-direction: column; 
            flex: 1; 
        }
        
        .btn-detail, .btn-pesan { 
            border-radius: 12px; 
            font-weight: 700; 
            padding: 12px 20px;
            text-decoration: none;
            text-align: center;
            transition: all 0.3s ease;
            font-size: 1em;
        }
        
        .btn-detail { 
            border: 2px solid #3a5eff; 
            color: #3a5eff; 
            background: #fff; 
        }
        
        .btn-detail:hover { 
            background: #3a5eff; 
            color: #fff; 
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(58,94,255,0.3);
        }
        
        .btn-pesan { 
            background: linear-gradient(45deg, #3a5eff, #6ea0ff);
            color: #fff; 
            border: none; 
        }
        
        .btn-pesan:hover { 
            background: linear-gradient(45deg, #1e2a78, #3a5eff);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(30,42,120,0.3);
        }
        
        .btn-pesan:disabled {
            background: #6c757d;
            cursor: not-allowed;
            transform: none;
        }
        
        .btn-pesan:disabled:hover {
            background: #6c757d;
            transform: none;
            box-shadow: none;
        }
        
        .card-kamar .btn-group { 
            gap: 12px; 
            margin-top: auto;
        }
        
        .footer-modern { 
            background: linear-gradient(90deg, #2360b7, #1e2a78);
            color: #fff; 
            text-align: center; 
            padding: 24px 0;
            margin-top: 60px;
        }
        
        .footer-modern .footer-copyright { 
            background: #e53935; 
            color: #fff; 
            padding: 12px 0; 
            font-weight: 700; 
            letter-spacing: 1px; 
        }
        
        .loading-spinner {
            display: none;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #3a5eff;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        @media (max-width: 768px) {
            .kamar-grid { 
                grid-template-columns: 1fr;
                gap: 24px;
                padding: 0 10px;
            }
            
            .hero-kamar-title {
                font-size: 2.5rem;
                letter-spacing: 2px;
            }
            
            .kamar-subtitle {
                font-size: 1.6rem;
                margin: 32px 0 24px 0;
            }
            
            .card-kamar {
                max-width: 100%;
            }
        }
        
        @media (max-width: 480px) {
            .hero-kamar-title {
                font-size: 2rem;
            }
            
            .kamar-subtitle {
                font-size: 1.4rem;
            }
            
            .card-kamar .card-body {
                padding: 20px;
            }
            
            .btn-detail, .btn-pesan {
                padding: 10px 16px;
                font-size: 0.9em;
            }
        }
    </style>
</head>
<body>

<!-- Hero Section -->
<div class="hero-kamar-bg">
    <div class="hero-kamar-title">KAMAR KAMI</div>
</div>

<div class="container">
    <div class="kamar-subtitle">Pilih Kamar</div>
    <div class="kamar-grid">
        <?php
        // Hitung stok tersedia per tipe dan id kamar yang tersedia
        $stokDeluxe = 0;
        $stokSuperior = 0;
        $deluxeId = null;
        $superiorId = null;
        foreach($kamarList as $kamar) {
            if (strtolower($kamar['tipe']) == 'deluxe') {
                if ($kamar['status'] === 'tersedia') {
                    $stokDeluxe++;
                    if (!$deluxeId) $deluxeId = $kamar['id'];
                }
            }
            if (strtolower($kamar['tipe']) == 'superior') {
                if ($kamar['status'] === 'tersedia') {
                    $stokSuperior++;
                    if (!$superiorId) $superiorId = $kamar['id'];
                }
            }
        }
        // Ambil 1 kamar deluxe dan 1 superior (bisa yang tidak tersedia jika stok 0)
        $deluxe = null;
        $superior = null;
        foreach($kamarList as $kamar) {
            if (strtolower($kamar['tipe']) == 'deluxe' && !$deluxe) $deluxe = $kamar;
            if (strtolower($kamar['tipe']) == 'superior' && !$superior) $superior = $kamar;
        }
        $tampil = [];
        if ($deluxe) $tampil[] = $deluxe;
        if ($superior) $tampil[] = $superior;
        foreach($tampil as $kamar):
            $stok = strtolower($kamar['tipe']) == 'deluxe' ? $stokDeluxe : $stokSuperior;
            $idTersedia = strtolower($kamar['tipe']) == 'deluxe' ? $deluxeId : $superiorId;
        ?>
            <div class="card-kamar">
                <div class="image-container">
                    <?php if(!empty($kamar['promo'])): ?>
                        <span class="badge-promo">PROMO!</span>
                    <?php endif; ?>
                    <img 
                        src="<?= $gambarKamarAngMansion ?>"
                        alt="<?= htmlspecialchars($kamar['tipe']) ?>"
                        onerror="this.onerror=null;this.src='<?= $gambarKamarAngMansion ?>';"
                    >
                </div>
                <div class="card-body">
                    <div class="kamar-nama"><?= htmlspecialchars($kamar['tipe']) ?></div>
                    <div class="kamar-harga">Rp<?= number_format($kamar['harga'],0,',','.') ?> / bulan</div>
                    <div class="badge-status badge-tersedia">
                        <?= $stok ?> kamar tersedia
                    </div>
                    <div class="btn-group" style="display:flex;gap:12px;">
                        <a href="kamar_detail.php?id=<?= $kamar['id'] ?>" class="btn-detail">Lihat Detail</a>
                        <?php if($stok > 0): ?>
                            <a href="reservasi.php?id=<?= $idTersedia ?>" class="btn-pesan">Pesan Sekarang</a>
                        <?php else: ?>
                            <button class="btn-pesan" disabled>Tidak Tersedia</button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<footer class="footer-modern">
    <div class="container">
        <p>&copy; 2024 AngMansion. Semua hak cipta dilindungi.</p>
    </div>
    <div class="footer-copyright">
        Developed with ❤️ by AngMansion Team
    </div>
</footer>

<script>
// Smooth scrolling untuk navigasi
document.addEventListener('DOMContentLoaded', function() {
    // Fade in animation untuk card kamar
    const cards = document.querySelectorAll('.card-kamar');
    cards.forEach((card, index) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        setTimeout(() => {
            card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            card.style.opacity = '1';
            card.style.transform = 'translateY(0)';
        }, index * 100);
    });
    
    // Lazy loading untuk gambar
    const images = document.querySelectorAll('.card-kamar img');
    const imageObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const img = entry.target;
                img.src = img.src; // Trigger loading
                observer.unobserve(img);
            }
        });
    });
    
    images.forEach(img => imageObserver.observe(img));
    
    // Smooth hover effect untuk tombol
    const buttons = document.querySelectorAll('.btn-detail, .btn-pesan');
    buttons.forEach(button => {
        button.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-2px)';
        });
        
        button.addEventListener('mouseleave', function() {
            if (!this.disabled) {
                this.style.transform = 'translateY(0)';
            }
        });
    });
});

// Fungsi untuk filter kamar (bisa dikembangkan lebih lanjut)
function filterKamar(status) {
    const cards = document.querySelectorAll('.card-kamar');
    cards.forEach(card => {
        const badge = card.querySelector('.badge-status');
        if (status === 'all' || badge.textContent.includes(status)) {
            card.style.display = 'flex';
        } else {
            card.style.display = 'none';
        }
    });
}

// Fungsi untuk menampilkan loading
function showLoading() {
    document.getElementById('loadingSpinner').style.display = 'block';
    document.getElementById('kamarGrid').style.opacity = '0.5';
}

function hideLoading() {
    document.getElementById('loadingSpinner').style.display = 'none';
    document.getElementById('kamarGrid').style.opacity = '1';
}
</script>

</body>
</html>