<?php
session_start();
include '../config/koneksi.php';
$isLogin = isset($_SESSION['user_id']);
$userNama = $isLogin ? $_SESSION['user_nama'] : '';
$activePage = 'beranda';

// Ambil data user jika login
$user = null;
if($isLogin){
    $userId = $_SESSION['user_id'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}

include 'header.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Ang Mansion - Beranda</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
</head>
<body>

<div class="hero" style="font-size:2em; background: linear-gradient(90deg,rgba(30,42,120,0.7),rgba(30,42,120,0.3)), url('../assets/images/angMansion.jpg') center/cover no-repeat; min-height: 200px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
    <span style="color:#ffe600;font-weight:700;font-size:1.3em;">Selamat Datang di Ang Mansion</span><br>
    <span class="subtitle">Sistem Pemesanan Kamar Kos Modern & Nyaman</span>
</div>

<div class="section">
    <div class="section-title">Fasilitas AngMansion</div>
    <div style="display: flex; flex-wrap: wrap; gap: 24px; justify-content: center;">
        <div style="background:#fff;border-radius:16px;box-shadow:0 2px 12px rgba(30,42,120,0.08);width:220px;padding:24px;display:flex;flex-direction:column;align-items:center;">
            <span style="font-size:2em;">📶</span>
            <div style="font-weight:700;margin-top:10px;">WiFi Cepat</div>
            <div style="font-size:0.95em;color:#555;text-align:center;">Akses internet 24 jam di seluruh area kos.</div>
        </div>
        <div style="background:#fff;border-radius:16px;box-shadow:0 2px 12px rgba(30,42,120,0.08);width:220px;padding:24px;display:flex;flex-direction:column;align-items:center;">
            <span style="font-size:2em;">❄️</span>
            <div style="font-weight:700;margin-top:10px;">AC Setiap Kamar</div>
            <div style="font-size:0.95em;color:#555;text-align:center;">Fasilitas AC hanya tersedia di kamar tipe Deluxe.</div>
        </div>
        <div style="background:#fff;border-radius:16px;box-shadow:0 2px 12px rgba(30,42,120,0.08);width:220px;padding:24px;display:flex;flex-direction:column;align-items:center;">
            <span style="font-size:2em;">🚿</span>
            <div style="font-weight:700;margin-top:10px;">Kamar Mandi Dalam</div>
            <div style="font-size:0.95em;color:#555;text-align:center;">Privasi lebih dengan kamar mandi di dalam.</div>
        </div>
        <div style="background:#fff;border-radius:16px;box-shadow:0 2px 12px rgba(30,42,120,0.08);width:220px;padding:24px;display:flex;flex-direction:column;align-items:center;">
            <span style="font-size:2em;">🍳</span>
            <div style="font-weight:700;margin-top:10px;">Dapur Bersama</div>
            <div style="font-size:0.95em;color:#555;text-align:center;">Dapur lengkap untuk kebutuhan memasak Anda.</div>
        </div>
        <div style="background:#fff;border-radius:16px;box-shadow:0 2px 12px rgba(30,42,120,0.08);width:220px;padding:24px;display:flex;flex-direction:column;align-items:center;">
            <span style="font-size:2em;">🅿️</span>
            <div style="font-weight:700;margin-top:10px;">Parkir Luas</div>
            <div style="font-size:0.95em;color:#555;text-align:center;">Area parkir aman dan luas untuk penghuni.</div>
        </div>
        <div style="background:#fff;border-radius:16px;box-shadow:0 2px 12px rgba(30,42,120,0.08);width:220px;padding:24px;display:flex;flex-direction:column;align-items:center;">
            <span style="font-size:2em;">🛡️</span>
            <div style="font-weight:700;margin-top:10px;">Keamanan 24 Jam</div>
            <div style="font-size:0.95em;color:#555;text-align:center;">CCTV & penjaga untuk keamanan Anda.</div>
        </div>
    </div>
</div>

<div class="section">
    <div class="section-title">Tentang Kami</div>
    <p style="text-align:center;max-width:700px;margin:0 auto 10px auto;">
        Ang Mansion merupakan kos-kosan yang menawarkan kenyamanan dan keamanan bagi para penghuni, dengan fasilitas lengkap dan lingkungan yang tenang.<br>
        Kami hadir untuk memberikan hunian yang bersih, rapi, dan strategis, cocok untuk mahasiswa, pekerja, maupun siapa pun yang membutuhkan tempat tinggal yang praktis dan nyaman. Dengan pelayanan yang ramah serta suasana seperti di rumah sendiri, Ang Mansion adalah pilihan tepat untuk Anda yang mencari tempat tinggal terbaik di kawasan ini.
    </p>
</div>

<div class="section-map">
    <div class="section-title">Peta Lokasi</div>
    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3952.934073964049!2d123.607!3d-10.163!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2db3bf3e2e2e2e2b%3A0x2e2e2e2e2e2e2e2e!2sAng%20Mansion!5e0!3m2!1sid!2sid!4v1680000000000!5m2!1sid!2sid" width="100%" height="320" style="border:0;border-radius:12px;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
</div>

<!-- Footer Modern Dark -->
<footer class="footer-dark">
  <div class="footer-dark-main" style="display:flex;justify-content:space-between;align-items:flex-start;gap:40px;">
    <div class="footer-dark-col brand" style="flex:1;min-width:200px;">
      <div class="footer-dark-logo">AngMansion</div>
      <div class="footer-dark-desc">Kos modern, nyaman, dan strategis untuk kebutuhan hunian Anda.</div>
    </div>
    <div class="footer-dark-col social" style="flex:1;min-width:200px;display:flex;flex-direction:column;align-items:flex-end;">
      <div class="footer-dark-title">FOLLOW US</div>
      <div class="footer-dark-social" style="display:flex;gap:18px;justify-content:flex-end;">
        <a href="#" title="Instagram"><svg width="22" height="22" fill="currentColor"><use xlink:href="#icon-ig"/></svg></a>
        <a href="#" title="Facebook"><svg width="22" height="22" fill="currentColor"><use xlink:href="#icon-fb"/></svg></a>
        <a href="#" title="Twitter"><svg width="22" height="22" fill="currentColor"><use xlink:href="#icon-tw"/></svg></a>
      </div>
    </div>
  </div>
  <div class="footer-dark-bottom">
    <div class="footer-dark-copyright">&copy; 2025 Ang Mansion. All Rights Reserved</div>
    <div class="footer-dark-links">
      <a href="#">PRIVACY POLICY</a>
      <a href="#">TERMS AND CONDITIONS</a>
    </div>
  </div>
  <!-- SVG ICONS -->
  <svg style="display:none;">
    <symbol id="icon-fb" viewBox="0 0 16 16"><path d="M8.94 8.5H10.5V16H7.5V8.5H6V6.5h1.5V5.5c0-1.104.896-2 2-2h1.5v2H10.5c-.276 0-.5.224-.5.5v1h2l-.5 2H10.5V16H8.94V8.5z"/></symbol>
    <symbol id="icon-tw" viewBox="0 0 16 16"><path d="M16 3.039a6.461 6.461 0 0 1-1.885.516A3.301 3.301 0 0 0 15.555 1.8a6.533 6.533 0 0 1-2.084.797A3.286 3.286 0 0 0 7.88 4.03c0 .258.03.51.085.75A9.325 9.325 0 0 1 1.112 2.1a3.284 3.284 0 0 0 1.018 4.381A3.323 3.323 0 0 1 .64 6.575v.041a3.288 3.288 0 0 0 2.632 3.218c-.23.062-.473.096-.724.096-.177 0-.348-.017-.516-.049a3.293 3.293 0 0 0 3.067 2.281A6.588 6.588 0 0 1 .78 13.58a6.32 6.32 0 0 1-.78-.045A9.344 9.344 0 0 0 5.026 15c6.038 0 9.341-5.003 9.341-9.334 0-.142-.004-.284-.01-.425A6.673 6.673 0 0 0 16 3.039z"/></symbol>
    <symbol id="icon-ig" viewBox="0 0 16 16"><path d="M8 3a5 5 0 1 0 0 10A5 5 0 0 0 8 3zm0 8.5A3.5 3.5 0 1 1 8 4.5a3.5 3.5 0 0 1 0 7zm5-8.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zm-1 0v10a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1z"/></symbol>
  </svg>
</footer>
</body>
</html> 