<?php
session_start();
include '../config/koneksi.php';
$user = null;
$userNama = '';
$isLogin = isset($_SESSION['user_id']);
if($isLogin){
    $userId = $_SESSION['user_id'];
    $userNama = $_SESSION['user_nama'];
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
}
$activePage = '';
include 'header.php';
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
// Ambil data pemesanan dan kamar
$q = mysqli_query($conn, "SELECT p.*, k.tipe, k.harga, k.gambar FROM pemesanan p JOIN kamar k ON p.id_kamar = k.id WHERE p.id = $id AND p.id_user = $userId");
$pemesanan = mysqli_fetch_assoc($q);
if (!$pemesanan) {
    echo '<h2>Data pemesanan tidak ditemukan.</h2>';
    exit;
}
// Ambil riwayat pembayaran
$qBayar = mysqli_query($conn, "SELECT * FROM pembayaran WHERE id_user = $userId AND id_pemesanan = $id ORDER BY tanggal_bayar DESC");
$riwayatBayar = [];
while($row = mysqli_fetch_assoc($qBayar)) {
    $riwayatBayar[] = $row;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Pemesanan - AngMansion</title>
    <link rel="stylesheet" type="text/css" href="../assets/style_user.css">
    <style>
        body { background: #f4f8ff; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .container { max-width: 700px; margin: 40px auto; background: #fff; border-radius: 18px; box-shadow: 0 4px 20px rgba(30,42,120,0.08); padding: 32px; }
        .detail-title { font-size: 2em; font-weight: 800; color: #1e2a78; margin-bottom: 24px; }
        .kamar-info { display: flex; gap: 24px; align-items: flex-start; margin-bottom: 24px; }
        .kamar-info img { width: 120px; height: 90px; object-fit: cover; border-radius: 10px; }
        .kamar-meta { font-size: 1.1em; }
        .kamar-meta strong { color: #1e2a78; }
        .meta-table { width: 100%; margin-bottom: 24px; }
        .meta-table td { padding: 6px 10px; }
        .badge-status { font-size: 1em; font-weight: 600; border-radius: 20px; padding: 6px 16px; display: inline-block; }
        .badge-pending { background: #fff3cd; color: #856404; border: 1px solid #ffeeba; }
        .badge-sukses { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .badge-batal { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .badge-lain { background: #e2e3e5; color: #383d41; border: 1px solid #d6d8db; }
        .riwayat-title { font-size: 1.2em; font-weight: 700; color: #3a5eff; margin-bottom: 10px; }
        .riwayat-table { width: 100%; border-collapse: collapse; margin-bottom: 18px; }
        .riwayat-table th, .riwayat-table td { padding: 8px 10px; border-bottom: 1px solid #e0eaff; text-align: left; }
        .riwayat-table th { background: #f4f8ff; color: #3a5eff; font-weight: 700; }
        .bukti-img { max-width: 80px; max-height: 60px; border-radius: 6px; }
    </style>
</head>
<body>
<div class="container">
    <div class="detail-title">Detail Pemesanan</div>
    <div class="kamar-info">
        <img src="../assets/images/<?= htmlspecialchars($pemesanan['gambar']) ?>" alt="Kamar">
        <div class="kamar-meta">
            <div><strong>Tipe:</strong> <?= htmlspecialchars($pemesanan['tipe']) ?></div>
            <div><strong>Harga:</strong> Rp<?= number_format($pemesanan['harga'],0,',','.') ?> / bulan</div>
        </div>
    </div>
    <table class="meta-table">
        <tr><td><strong>Tanggal Pesan</strong></td><td><?= date('d/m/Y', strtotime($pemesanan['tanggal_pesan'])) ?></td></tr>
        <tr><td><strong>Tanggal Masuk</strong></td><td><?= date('d/m/Y', strtotime($pemesanan['tanggal_masuk'])) ?></td></tr>
        <tr><td><strong>Tanggal Keluar</strong></td><td><?= date('d/m/Y', strtotime($pemesanan['tanggal_keluar'])) ?></td></tr>
        <tr><td><strong>Status</strong></td><td>
            <?php
            $status = strtolower($pemesanan['status']);
            if($status == 'pending') echo '<span class="badge-status badge-pending">Pending</span>';
            else if($status == 'lunas') echo '<span class="badge-status badge-sukses">Lunas</span>';
            else if($status == 'expired') echo '<span class="badge-status badge-batal">Expired</span>';
            else echo '<span class="badge-status badge-lain">'.htmlspecialchars($pemesanan['status']).'</span>';
            ?>
        </td></tr>
        <tr><td><strong>Catatan</strong></td><td><?= htmlspecialchars($pemesanan['catatan']) ?></td></tr>
    </table>
    <div class="riwayat-title">Riwayat Pembayaran</div>
    <?php if(empty($riwayatBayar)): ?>
        <div style="color:#888;">Belum ada pembayaran untuk pesanan ini.</div>
    <?php else: ?>
    <table class="riwayat-table">
        <thead>
            <tr>
                <th>Tanggal Bayar</th>
                <th>Bank</th>
                <th>Jumlah</th>
                <th>Nama Pemilik</th>
                <th>Bukti</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($riwayatBayar as $b): ?>
            <tr>
                <td><?= date('d/m/Y', strtotime($b['tanggal_bayar'])) ?></td>
                <td><?= htmlspecialchars($b['bank']) ?></td>
                <td>Rp<?= number_format($b['jumlah'],0,',','.') ?></td>
                <td><?= htmlspecialchars($b['nama_pemilik']) ?></td>
                <td>
                    <?php if($b['bukti']): ?>
                        <a href="../assets/images/<?= htmlspecialchars($b['bukti']) ?>" target="_blank"><img src="../assets/images/<?= htmlspecialchars($b['bukti']) ?>" class="bukti-img" alt="Bukti"></a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <?php endif; ?>
    <a href="riwayat_pemesanan.php" class="btn-detail">&larr; Kembali ke Riwayat</a>
</div>
</body>
</html> 