<?php
// File test untuk memverifikasi perbaikan fitur upload foto profil
session_start();
include 'config/koneksi.php';

echo "<h1>🧪 Test Perbaikan Fitur Upload Foto Profil</h1>";

// Cek koneksi database
if($conn) {
    echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Koneksi database berhasil</div>";
} else {
    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Koneksi database gagal</div>";
    exit;
}

// Cek kolom foto
$checkColumn = mysqli_query($conn, "SHOW COLUMNS FROM user LIKE 'foto'");
if(mysqli_num_rows($checkColumn) > 0) {
    echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Kolom 'foto' ada di tabel user</div>";
} else {
    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Kolom 'foto' tidak ada di tabel user</div>";
}

// Cek direktori profile
$profileDir = 'assets/images/profile';
if(is_dir($profileDir)) {
    echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Direktori profile ada: $profileDir</div>";
    
    if(is_writable($profileDir)) {
        echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Direktori profile dapat ditulis</div>";
    } else {
        echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Direktori profile tidak dapat ditulis</div>";
    }
} else {
    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Direktori profile tidak ada: $profileDir</div>";
}

// Cek user yang sudah login
if(isset($_SESSION['user_id'])) {
    $userId = $_SESSION['user_id'];
    $userNama = $_SESSION['user_nama'];
    echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ User sudah login: $userNama (ID: $userId)</div>";
    
    // Ambil data user
    $q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
    $user = mysqli_fetch_assoc($q);
    
    if($user) {
        echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Data user berhasil diambil</div>";
        
        if(isset($user['foto']) && $user['foto']) {
            $fotoPath = $profileDir . '/' . $user['foto'];
            if(file_exists($fotoPath)) {
                echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Foto profil ada: $user[foto]</div>";
                echo "<img src='$fotoPath' style='max-width: 200px; border-radius: 10px; margin: 10px 0;' alt='Foto Profil'>";
            } else {
                echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ File foto tidak ada: $fotoPath</div>";
            }
        } else {
            echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ User belum memiliki foto profil</div>";
        }
    } else {
        echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Gagal mengambil data user</div>";
    }
} else {
    echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ User belum login</div>";
}

// Test fitur yang sudah diperbaiki
echo "<h3>🔧 Fitur yang Sudah Diperbaiki:</h3>";
echo "<ul>";
echo "<li>✅ Alert muncul sebentar (3 detik) lalu hilang otomatis</li>";
echo "<li>✅ Alert muncul di pojok kanan atas (fixed position)</li>";
echo "<li>✅ Scroll tidak otomatis naik ke atas saat submit form</li>";
echo "<li>✅ Foto profil muncul di avatar header</li>";
echo "<li>✅ Validasi file yang lebih ketat</li>";
echo "<li>✅ Error handling yang lebih baik</li>";
echo "</ul>";

// Test form upload
echo "<h3>📤 Test Upload Foto</h3>";
if(isset($_SESSION['user_id'])) {
    echo "<form method='post' enctype='multipart/form-data' style='background: #f8f9fa; padding: 20px; border-radius: 10px; margin: 10px 0;'>";
    echo "<div style='margin-bottom: 15px;'>";
    echo "<label for='test_foto' style='display: block; margin-bottom: 5px; font-weight: bold;'>Pilih file foto:</label>";
    echo "<input type='file' name='test_foto' id='test_foto' accept='image/*' required>";
    echo "</div>";
    echo "<button type='submit' name='test_upload' style='background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;'>Test Upload</button>";
    echo "</form>";
    
    // Proses test upload
    if(isset($_POST['test_upload']) && isset($_FILES['test_foto']) && $_FILES['test_foto']['error'] == 0) {
        $file = $_FILES['test_foto'];
        $fileName = $file['name'];
        $fileSize = $file['size'];
        $fileTmp = $file['tmp_name'];
        $fileType = $file['type'];
        
        echo "<h4>📋 Hasil Test Upload:</h4>";
        echo "<ul>";
        echo "<li>Nama file: $fileName</li>";
        echo "<li>Ukuran: " . number_format($fileSize / 1024, 2) . " KB</li>";
        echo "<li>Tipe: $fileType</li>";
        echo "</ul>";
        
        // Validasi
        if($fileSize > 5 * 1024 * 1024) {
            echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Ukuran file terlalu besar! Maksimal 5MB.</div>";
        } else {
            $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
            if(!in_array($fileType, $allowedTypes)) {
                echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Tipe file tidak didukung!</div>";
            } else {
                $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                $newFileName = 'test_' . time() . '.' . $ext;
                $uploadPath = $profileDir . '/' . $newFileName;
                
                if(move_uploaded_file($fileTmp, $uploadPath)) {
                    echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Test upload berhasil! File: $newFileName</div>";
                    echo "<img src='$uploadPath' style='max-width: 200px; border-radius: 10px; margin: 10px 0;' alt='Test Upload'>";
                } else {
                    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Test upload gagal!</div>";
                }
            }
        }
    }
} else {
    echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ Silakan login terlebih dahulu untuk test upload</div>";
}

echo "<br><a href='user/profile.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>🏠 Kembali ke Profile</a>";
echo " | <a href='user/index.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>�� Beranda</a>";
?> 