<?php
// File test khusus untuk avatar di halaman profil
session_start();
include 'config/koneksi.php';

if(!isset($_SESSION['user_id'])) {
    echo "User belum login";
    exit;
}

$userId = $_SESSION['user_id'];
$userNama = $_SESSION['user_nama'];

// Ambil data user
$q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
$user = mysqli_fetch_assoc($q);

echo "<h1>🎯 Test Avatar di Halaman Profil</h1>";
echo "<p><strong>User:</strong> $userNama (ID: $userId)</p>";

// Test avatar logic seperti di header.php
echo "<h3>🖼️ Test Avatar Logic:</h3>";

$fotoPath = '../assets/images/LogoAngMansion-Putih.png'; // Default path

if(isset($user['foto']) && !empty($user['foto'])) {
    $userFotoPath = '../assets/images/profile/' . $user['foto'];
    echo "<p><strong>Foto user:</strong> $user[foto]</p>";
    echo "<p><strong>Path foto:</strong> $userFotoPath</p>";
    
    if(file_exists($userFotoPath)) {
        $fotoPath = $userFotoPath;
        echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Foto profil ditemukan!</div>";
    } else {
        echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ File foto tidak ditemukan</div>";
    }
} else {
    echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ User belum memiliki foto profil</div>";
}

echo "<h4>🎨 Avatar Preview (seperti di header):</h4>";
echo "<div style='display: flex; align-items: center; gap: 20px; margin: 20px 0;'>";
echo "<div style='width: 38px; height: 38px; border-radius: 50%; background: #fff; border: 2.5px solid #3a5eff; box-shadow: 0 2px 8px rgba(30,42,120,0.10); overflow: hidden; position: relative;'>";
echo "<img src='$fotoPath' alt='avatar' style='width: 100%; height: 100%; object-fit: cover; border-radius: 50%; position: absolute; top: 0; left: 0;' onerror=\"this.src='../assets/images/LogoAngMansion-Putih.png'\">";
echo "</div>";
echo "<span style='font-weight: bold; color: #333;'>$userNama</span>";
echo "</div>";

echo "<h4>📊 Informasi Detail:</h4>";
echo "<ul>";
echo "<li><strong>Path yang digunakan:</strong> $fotoPath</li>";
echo "<li><strong>File exists:</strong> " . (file_exists($fotoPath) ? '✅ Ya' : '❌ Tidak') . "</li>";
echo "<li><strong>Ukuran file:</strong> " . (file_exists($fotoPath) ? number_format(filesize($fotoPath) / 1024, 2) . ' KB' : 'N/A') . "</li>";
echo "<li><strong>User foto field:</strong> " . (isset($user['foto']) ? $user['foto'] : 'NULL') . "</li>";
echo "</ul>";

// Test apakah data user sudah benar
echo "<h4>🔍 Data User:</h4>";
echo "<pre>";
print_r($user);
echo "</pre>";

echo "<br><a href='user/profile.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>🏠 Kembali ke Profile</a>";
echo " | <a href='user/index.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>�� Beranda</a>";
?> 