<?php
// Test file untuk memeriksa koneksi database dan konfigurasi
echo "<h1>Ang Mansion - Test Connection</h1>";

// Test 1: Check if config file exists
if (file_exists('config/koneksi.php')) {
    echo "<p style='color: green;'>✓ File config/koneksi.php ditemukan</p>";
} else {
    echo "<p style='color: red;'>✗ File config/koneksi.php tidak ditemukan</p>";
}

// Test 2: Check database connection
try {
    include 'config/koneksi.php';
    if ($conn) {
        echo "<p style='color: green;'>✓ Koneksi database berhasil</p>";
        
        // Test 3: Check if database exists
        $result = mysqli_query($conn, "SHOW TABLES");
        if ($result) {
            $table_count = mysqli_num_rows($result);
            echo "<p style='color: green;'>✓ Database ditemukan dengan $table_count tabel</p>";
        } else {
            echo "<p style='color: red;'>✗ Database tidak ditemukan atau kosong</p>";
        }
    } else {
        echo "<p style='color: red;'>✗ Koneksi database gagal</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error: " . $e->getMessage() . "</p>";
}

// Test 4: Check file structure
echo "<h2>File Structure Check:</h2>";
$required_files = [
    'user/index.php',
    'admin/index.php',
    'assets/style_user.css',
    'sql/angmansion_kos.sql'
];

foreach ($required_files as $file) {
    if (file_exists($file)) {
        echo "<p style='color: green;'>✓ $file ditemukan</p>";
    } else {
        echo "<p style='color: red;'>✗ $file tidak ditemukan</p>";
    }
}

echo "<h2>Next Steps:</h2>";
echo "<ol>";
echo "<li>Pastikan Apache dan MySQL berjalan</li>";
echo "<li>Import database dari file sql/angmansion_kos.sql</li>";
echo "<li>Akses <a href='user/index.php'>user/index.php</a></li>";
echo "<li>Akses <a href='admin/index.php'>admin/index.php</a></li>";
echo "</ol>";
?> 