CREATE DATABASE angmansion_kos;
USE angmansion_kos;

-- Tabel user
CREATE TABLE user (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama VARCHAR(100),
    email VARCHAR(100) UNIQUE,
    password VARCHAR(255),
    alamat VARCHAR(255),
    telepon VARCHAR(20),
    foto VARCHAR(255) DEFAULT NULL
);

-- Tabel admin
CREATE TABLE admin (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE,
    password VARCHAR(255)
);

-- Tabel fasilitas
CREATE TABLE fasilitas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama VARCHAR(100),
    deskripsi TEXT
);

-- Tabel kamar
CREATE TABLE kamar (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama VARCHAR(100),
    tipe VARCHAR(50),
    harga INT,
    status ENUM('tersedia','terisi') DEFAULT 'tersedia',
    gambar VARCHAR(255)
);

-- Tabel pemesanan
CREATE TABLE pemesanan (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_user INT,
    id_kamar INT,
    tanggal_pesan DATE,
    tanggal_masuk DATE,
    tanggal_keluar DATE,
    status ENUM('pending','diterima','ditolak') DEFAULT 'pending',
    FOREIGN KEY (id_user) REFERENCES user(id),
    FOREIGN KEY (id_kamar) REFERENCES kamar(id)
);

-- Tabel relasi kamar-fasilitas
CREATE TABLE kamar_fasilitas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_kamar INT,
    id_fasilitas INT,
    FOREIGN KEY (id_kamar) REFERENCES kamar(id),
    FOREIGN KEY (id_fasilitas) REFERENCES fasilitas(id)
);

-- Tabel pembayaran
CREATE TABLE pembayaran (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_user INT,
    id_pemesanan INT,
    nama VARCHAR(100),
    jumlah INT,
    bank VARCHAR(50),
    no_rekening VARCHAR(50),
    nama_pemilik VARCHAR(100),
    bukti VARCHAR(255),
    tanggal_bayar DATE,
    FOREIGN KEY (id_user) REFERENCES user(id),
    FOREIGN KEY (id_pemesanan) REFERENCES pemesanan(id)
);

-- Tabel kontak
CREATE TABLE kontak (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_user INT,
    nama_user VARCHAR(100),
    pesan TEXT,
    balasan TEXT,
    tanggal DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (id_user) REFERENCES user(id)
);

-- Tabel untuk request layanan user
CREATE TABLE IF NOT EXISTS layanan_request (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    jenis_layanan VARCHAR(50),
    deskripsi TEXT,
    foto VARCHAR(255),
    status VARCHAR(20) DEFAULT 'Menunggu',
    balasan_admin TEXT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Admin default (username: viswa, password: viswacantik)
INSERT INTO admin (username, password) VALUES ('viswa', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');
-- Hash di atas adalah hasil password_hash('viswacantik', PASSWORD_DEFAULT) universal 