<?php
// Setup file untuk Ang Mansion
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo '<!DOCTYPE html>';
echo '<html><head><title>Ang Mansion - Setup</title>';
echo '<style>';
echo 'body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }';
echo '.container { max-width: 1000px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }';
echo '.success { color: #388e3c; background: #e8f5e8; padding: 15px; border-radius: 5px; margin: 20px 0; }';
echo '.error { color: #d32f2f; background: #ffebee; padding: 15px; border-radius: 5px; margin: 20px 0; }';
echo '.warning { color: #f57c00; background: #fff3e0; padding: 15px; border-radius: 5px; margin: 20px 0; }';
echo '.step { background: #f9f9f9; padding: 15px; margin: 10px 0; border-left: 4px solid #2196f3; }';
echo 'table { width: 100%; border-collapse: collapse; margin: 20px 0; }';
echo 'th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }';
echo 'th { background-color: #f2f2f2; }';
echo '</style></head><body>';

echo '<div class="container">';
echo '<h1>🔧 Ang Mansion - Setup & Troubleshooting</h1>';

// Check 1: File structure
echo '<h2>📁 File Structure Check</h2>';
$required_files = [
    'config/koneksi.php' => 'Database configuration',
    'user/index.php' => 'User panel main page',
    'admin/index.php' => 'Admin panel main page',
    'assets/style_user.css' => 'User stylesheet',
    'sql/angmansion_kos.sql' => 'Database structure',
    'assets/images/LogoAngMansion-Putih.png' => 'Logo image'
];

echo '<table>';
echo '<tr><th>File</th><th>Description</th><th>Status</th></tr>';

foreach ($required_files as $file => $desc) {
    if (file_exists($file)) {
        echo "<tr><td>$file</td><td>$desc</td><td style='color: green;'>✓ Found</td></tr>";
    } else {
        echo "<tr><td>$file</td><td>$desc</td><td style='color: red;'>✗ Missing</td></tr>";
    }
}
echo '</table>';

// Check 2: Database connection
echo '<h2>🗄️ Database Connection Check</h2>';
if (file_exists('config/koneksi.php')) {
    try {
        include 'config/koneksi.php';
        if ($conn) {
            echo '<div class="success">✓ Database connection successful</div>';
            
            // Check if database has tables
            $result = mysqli_query($conn, "SHOW TABLES");
            if ($result) {
                $tables = [];
                while ($row = mysqli_fetch_array($result)) {
                    $tables[] = $row[0];
                }
                
                if (count($tables) > 0) {
                    echo '<div class="success">✓ Database has ' . count($tables) . ' tables</div>';
                    echo '<ul>';
                    foreach ($tables as $table) {
                        echo "<li>$table</li>";
                    }
                    echo '</ul>';
                } else {
                    echo '<div class="warning">⚠ Database is empty. Please import sql/angmansion_kos.sql</div>';
                }
            }
        } else {
            echo '<div class="error">✗ Database connection failed</div>';
        }
    } catch (Exception $e) {
        echo '<div class="error">✗ Error: ' . $e->getMessage() . '</div>';
    }
} else {
    echo '<div class="error">✗ config/koneksi.php not found</div>';
}

// Check 3: PHP version
echo '<h2>🐘 PHP Version Check</h2>';
$php_version = phpversion();
echo "<p>Current PHP version: <strong>$php_version</strong></p>";
if (version_compare($php_version, '7.4.0', '>=')) {
    echo '<div class="success">✓ PHP version is compatible</div>';
} else {
    echo '<div class="warning">⚠ PHP version should be 7.4 or higher</div>';
}

// Check 4: Required PHP extensions
echo '<h2>🔌 PHP Extensions Check</h2>';
$required_extensions = ['mysqli', 'session', 'gd'];
echo '<ul>';
foreach ($required_extensions as $ext) {
    if (extension_loaded($ext)) {
        echo "<li style='color: green;'>✓ $ext extension loaded</li>";
    } else {
        echo "<li style='color: red;'>✗ $ext extension not loaded</li>";
    }
}
echo '</ul>';

// Setup instructions
echo '<h2>📋 Setup Instructions</h2>';
echo '<div class="step">';
echo '<h3>1. Start Server</h3>';
echo '<p>Make sure Apache and MySQL are running in XAMPP/Laragon</p>';
echo '</div>';

echo '<div class="step">';
echo '<h3>2. Import Database</h3>';
echo '<p>Open phpMyAdmin and import the file: <code>sql/angmansion_kos.sql</code></p>';
echo '</div>';

echo '<div class="step">';
echo '<h3>3. Access the Application</h3>';
echo '<ul>';
echo '<li><a href="user/index.php" target="_blank">User Panel</a></li>';
echo '<li><a href="admin/index.php" target="_blank">Admin Panel</a></li>';
echo '</ul>';
echo '</div>';

// Default credentials
echo '<h2>🔑 Default Credentials</h2>';
echo '<div class="step">';
echo '<h3>Admin Login</h3>';
echo '<p><strong>Username:</strong> viswa<br>';
echo '<strong>Password:</strong> viswacantik</p>';
echo '</div>';

echo '<h2>🔗 Quick Links</h2>';
echo '<ul>';
echo '<li><a href="user/index.php" target="_blank">🏠 User Homepage</a></li>';
echo '<li><a href="admin/index.php" target="_blank">⚙️ Admin Panel</a></li>';
echo '<li><a href="test_connection.php" target="_blank">🔍 Test Connection</a></li>';
echo '<li><a href="sql/angmansion_kos.sql" target="_blank">📄 Database SQL</a></li>';
echo '</ul>';

echo '</div></body></html>';
?> 