<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if user/index.php exists
if (file_exists('user/index.php')) {
    // Redirect to user index page
    header('Location: user/index.php');
    exit;
} else {
    // Show detailed error information
    echo '<!DOCTYPE html>';
    echo '<html><head><title>Ang Mansion - Setup Required</title>';
    echo '<style>';
    echo 'body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }';
    echo '.container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }';
    echo '.error { color: #d32f2f; background: #ffebee; padding: 15px; border-radius: 5px; margin: 20px 0; }';
    echo '.success { color: #388e3c; background: #e8f5e8; padding: 15px; border-radius: 5px; margin: 20px 0; }';
    echo '.step { background: #f9f9f9; padding: 15px; margin: 10px 0; border-left: 4px solid #2196f3; }';
    echo '</style></head><body>';
    
    echo '<div class="container">';
    echo '<h1>🚨 Ang Mansion - Setup Required</h1>';
    
    echo '<div class="error">';
    echo '<h2>Error: user/index.php not found</h2>';
    echo '<p>File user/index.php tidak ditemukan. Ini mungkin disebabkan oleh:</p>';
    echo '<ul>';
    echo '<li>File belum diupload dengan benar</li>';
    echo '<li>Struktur direktori tidak lengkap</li>';
    echo '<li>Permission file tidak sesuai</li>';
    echo '</ul>';
    echo '</div>';
    
    echo '<h2>📋 Langkah-langkah Setup:</h2>';
    
    echo '<div class="step">';
    echo '<h3>1. Pastikan Server Berjalan</h3>';
    echo '<p>✓ Apache dan MySQL harus aktif di XAMPP/Laragon</p>';
    echo '</div>';
    
    echo '<div class="step">';
    echo '<h3>2. Import Database</h3>';
    echo '<p>✓ Buka phpMyAdmin dan import file <code>sql/angmansion_kos.sql</code></p>';
    echo '</div>';
    
    echo '<div class="step">';
    echo '<h3>3. Periksa File Structure</h3>';
    echo '<p>✓ Pastikan semua file berada di folder yang benar</p>';
    echo '</div>';
    
    echo '<h2>🔗 Link Akses:</h2>';
    echo '<ul>';
    echo '<li><a href="user/index.php" target="_blank">User Panel</a></li>';
    echo '<li><a href="admin/index.php" target="_blank">Admin Panel</a></li>';
    echo '<li><a href="test_connection.php" target="_blank">Test Connection</a></li>';
    echo '</ul>';
    
    echo '<h2>📞 Support:</h2>';
    echo '<p>Jika masalah masih berlanjut, periksa:</p>';
    echo '<ul>';
    echo '<li>File <code>config/koneksi.php</code> untuk konfigurasi database</li>';
    echo '<li>Error log Apache/PHP</li>';
    echo '<li>Permission folder dan file</li>';
    echo '</ul>';
    
    echo '</div></body></html>';
}
?> 