<?php
// File untuk mengecek masalah avatar foto profil
session_start();
include 'config/koneksi.php';

echo "<h1>🔍 Cek Avatar Foto Profil</h1>";

if(!isset($_SESSION['user_id'])) {
    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ User belum login</div>";
    exit;
}

$userId = $_SESSION['user_id'];
$userNama = $_SESSION['user_nama'];

echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ User login: $userNama (ID: $userId)</div>";

// Ambil data user
$q = mysqli_query($conn, "SELECT * FROM user WHERE id=$userId");
$user = mysqli_fetch_assoc($q);

if(!$user) {
    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Gagal mengambil data user</div>";
    exit;
}

echo "<h3>📋 Data User:</h3>";
echo "<pre>";
print_r($user);
echo "</pre>";

// Cek foto profil
echo "<h3>📸 Cek Foto Profil:</h3>";

if(isset($user['foto']) && !empty($user['foto'])) {
    echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ User memiliki foto: $user[foto]</div>";
    
    $fotoPath = 'assets/images/profile/' . $user['foto'];
    $fotoPathFull = '../assets/images/profile/' . $user['foto'];
    
    echo "<p><strong>Path relatif:</strong> $fotoPath</p>";
    echo "<p><strong>Path full:</strong> $fotoPathFull</p>";
    
    if(file_exists($fotoPath)) {
        echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ File foto ada di direktori</div>";
        
        $fileSize = filesize($fotoPath);
        echo "<p><strong>Ukuran file:</strong> " . number_format($fileSize / 1024, 2) . " KB</p>";
        
        // Tampilkan foto
        echo "<h4>🖼️ Preview Foto:</h4>";
        echo "<img src='$fotoPath' style='max-width: 200px; border-radius: 10px; margin: 10px 0; border: 2px solid #ddd;' alt='Foto Profil'>";
        
        // Test path untuk header
        echo "<h4>🔗 Test Path untuk Header:</h4>";
        $headerPath = '../assets/images/profile/' . $user['foto'];
        echo "<p><strong>Path untuk header:</strong> $headerPath</p>";
        
        if(file_exists($headerPath)) {
            echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Path untuk header valid</div>";
            echo "<img src='$headerPath' style='max-width: 100px; border-radius: 50%; margin: 10px 0; border: 2px solid #3a5eff;' alt='Avatar'>";
        } else {
            echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Path untuk header tidak valid</div>";
        }
        
    } else {
        echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ File foto tidak ada di direktori</div>";
        
        // Cek direktori
        $profileDir = 'assets/images/profile';
        if(is_dir($profileDir)) {
            echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ Direktori profile ada</div>";
            
            $files = scandir($profileDir);
            echo "<h4>📁 File di direktori profile:</h4>";
            echo "<ul>";
            foreach($files as $file) {
                if($file != '.' && $file != '..') {
                    $filePath = $profileDir . '/' . $file;
                    $fileSize = filesize($filePath);
                    echo "<li>$file ($fileSize bytes)</li>";
                }
            }
            echo "</ul>";
        } else {
            echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Direktori profile tidak ada</div>";
        }
    }
} else {
    echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ User belum memiliki foto profil</div>";
}

// Test header.php logic
echo "<h3>🧪 Test Logic Header.php:</h3>";

$fotoPath = '../assets/images/LogoAngMansion-Putih.png'; // Default path

// Cek apakah user memiliki foto
if(isset($user['foto']) && !empty($user['foto'])) {
    $userFotoPath = '../assets/images/profile/' . $user['foto'];
    echo "<p><strong>User foto path:</strong> $userFotoPath</p>";
    
    // Cek apakah file foto benar-benar ada
    if(file_exists($userFotoPath)) {
        $fotoPath = $userFotoPath;
        echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ File foto ditemukan, akan menggunakan: $fotoPath</div>";
    } else {
        echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ File foto tidak ditemukan, akan menggunakan default: $fotoPath</div>";
    }
} else {
    echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ User tidak memiliki foto, akan menggunakan default: $fotoPath</div>";
}

echo "<h4>🎯 Hasil Akhir:</h4>";
echo "<p><strong>Path yang akan digunakan:</strong> $fotoPath</p>";
echo "<img src='$fotoPath' style='max-width: 100px; border-radius: 50%; margin: 10px 0; border: 2px solid #3a5eff;' alt='Avatar'>";

echo "<br><a href='user/profile.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>🏠 Kembali ke Profile</a>";
echo " | <a href='user/index.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>�� Beranda</a>";
?> 