<?php
include '../config/koneksi.php';
session_start();
if(!isset($_SESSION['admin_id'])){
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Data Pembayaran - Admin</title>
    <link rel="stylesheet" type="text/css" href="style_admin.css">
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>
<div class="content">
    <div class="box">
        <h2 style="text-align:center;">Data Pembayaran</h2>
        <table>
            <tr>
                <th>ID</th>
                <th>Nama User</th>
                <th>ID Pemesanan</th>
                <th>Jumlah</th>
                <th>Bank</th>
                <th>No Rekening</th>
                <th>Nama Pemilik</th>
                <th>Tanggal Bayar</th>
                <th>Bukti Pembayaran</th>
            </tr>
            <?php
            $q = mysqli_query($conn, "SELECT b.*, u.nama as nama_user FROM pembayaran b JOIN user u ON b.id_user=u.id ORDER BY b.id DESC");
            while($d = mysqli_fetch_assoc($q)){
                echo '<tr>';
                echo '<td>'.$d['id'].'</td>';
                echo '<td>'.htmlspecialchars($d['nama_user']).'</td>';
                echo '<td>'.$d['id_pemesanan'].'</td>';
                echo '<td>'.($d['jumlah'] ? 'Rp. '.number_format($d['jumlah'],0,',','.') : '-').'</td>';
                echo '<td>'.htmlspecialchars($d['bank']).'</td>';
                echo '<td>'.htmlspecialchars($d['no_rekening']).'</td>';
                echo '<td>'.htmlspecialchars($d['nama_pemilik']).'</td>';
                echo '<td>'.$d['tanggal_bayar'].'</td>';
                echo '<td>';
                if($d['bukti']){
                    echo '<a href="../assets/images/'.htmlspecialchars($d['bukti']).'" target="_blank">Lihat Bukti</a>';
                } else {
                    echo '-';
                }
                echo '</td>';
                echo '</tr>';
            }
            ?>
        </table>
    </div>
</div>
<?php include 'footer.php'; ?>
</body>
</html> 