<?php
session_start();
include '../config/koneksi.php';
// (Opsional) Cek login admin di sini

// Proses update status/balasan
if(isset($_POST['update_status'])){
    $id = intval($_POST['id']);
    $status = mysqli_real_escape_string($conn, $_POST['status']);
    $balasan = mysqli_real_escape_string($conn, $_POST['balasan_admin']);
    mysqli_query($conn, "UPDATE layanan_request SET status='$status', balasan_admin='$balasan' WHERE id=$id");
    echo '<div class="alert" style="background:#d4edda;color:#155724;">Status/balasan berhasil diupdate!</div>';
}
// Ambil semua request
$all = mysqli_query($conn, "SELECT lr.*, u.nama, u.email FROM layanan_request lr LEFT JOIN user u ON lr.user_id=u.id ORDER BY lr.created_at DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin - Request Layanan</title>
    <link rel="stylesheet" type="text/css" href="style_admin.css">
    <style>
        .request-table { width: 100%; border-collapse: collapse; margin-top: 24px; }
        .request-table th, .request-table td { border: 1px solid #e0e7ef; padding: 8px 10px; text-align: left; }
        .request-table th { background: #f4f8ff; color: #2563eb; }
        .request-table td.status-menunggu { color: #f59e0b; font-weight: 600; }
        .request-table td.status-diproses { color: #2563eb; font-weight: 600; }
        .request-table td.status-selesai { color: #22c55e; font-weight: 600; }
        .request-table td.status-ditolak { color: #ef4444; font-weight: 600; }
        .admin-form { margin:0; }
        .admin-form textarea { width: 100%; min-height: 40px; }
        .admin-form select, .admin-form button { padding: 4px 8px; }
    </style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>
<div class="content">
    <div class="box">
        <h2 style="text-align:center;">Daftar Request Layanan Penghuni</h2>
        <?php if(!$all): ?>
            <div class="alert">Terjadi kesalahan query: <?php echo mysqli_error($conn); ?></div>
        <?php else: ?>
        <table class="request-table">
            <tr>
                <th>Tanggal</th>
                <th>User</th>
                <th>Jenis</th>
                <th>Deskripsi</th>
                <th>Status</th>
                <th>Balasan Admin</th>
                <th>Foto</th>
                <th>Aksi</th>
            </tr>
            <?php while($r = mysqli_fetch_assoc($all)): ?>
            <tr>
                <td><?php echo date('d-m-Y H:i', strtotime($r['created_at'])); ?></td>
                <td><?php
                    $nama = isset($r['nama']) && $r['nama'] !== null ? $r['nama'] : '';
                    echo htmlspecialchars($nama);
                ?></td>
                <td><?php echo htmlspecialchars($r['jenis_layanan']); ?></td>
                <td><?php echo nl2br(htmlspecialchars($r['deskripsi'])); ?></td>
                <td class="status-<?php echo strtolower($r['status']); ?>"> <?php echo htmlspecialchars($r['status']); ?> </td>
                <td><?php echo $r['balasan_admin'] ? nl2br(htmlspecialchars($r['balasan_admin'])) : '-'; ?></td>
                <td><?php if($r['foto']): ?><a href="../assets/images/<?php echo htmlspecialchars($r['foto']); ?>" target="_blank">Lihat</a><?php else: ?>-<?php endif; ?></td>
                <td>
                    <form method="post" class="admin-form">
                        <input type="hidden" name="id" value="<?php echo $r['id']; ?>">
                        <select name="status">
                            <option value="Menunggu" <?php if($r['status']=='Menunggu') echo 'selected'; ?>>Menunggu</option>
                            <option value="Diproses" <?php if($r['status']=='Diproses') echo 'selected'; ?>>Diproses</option>
                            <option value="Selesai" <?php if($r['status']=='Selesai') echo 'selected'; ?>>Selesai</option>
                            <option value="Ditolak" <?php if($r['status']=='Ditolak') echo 'selected'; ?>>Ditolak</option>
                        </select><br>
                        <?php $balasan = isset($r['balasan_admin']) && $r['balasan_admin'] !== null ? $r['balasan_admin'] : ''; ?>
                        <textarea name="balasan_admin" placeholder="Balasan admin..."><?php echo htmlspecialchars($balasan); ?></textarea>
                        <button type="submit" name="update_status">Update</button>
                    </form>
                </td>
            </tr>
            <?php endwhile; ?>
        </table>
        <?php endif; ?>
    </div>
</div>
</body>
</html> 