<?php
include '../config/koneksi.php';
session_start();
if(!isset($_SESSION['admin_id'])){ header('Location: login.php'); exit; }
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if($id <= 0) { echo '<h2>ID kamar tidak valid.</h2>'; exit; }
// Ambil data kamar
$q = mysqli_query($conn, "SELECT * FROM kamar WHERE id=$id");
$kamar = mysqli_fetch_assoc($q);
if(!$kamar) { echo '<h2>Data kamar tidak ditemukan.</h2>'; exit; }
$success = false;
if($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $tipe = mysqli_real_escape_string($conn, $_POST['tipe']);
    $harga = intval($_POST['harga']);
    $status = mysqli_real_escape_string($conn, $_POST['status']);
    $sql = "UPDATE kamar SET nama='$nama', tipe='$tipe', harga=$harga, status='$status' WHERE id=$id";
    if(mysqli_query($conn, $sql)) {
        header('Location: kamar_data.php?notif=1');
        exit;
    } else {
        $success = false;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Kamar - Admin</title>
    <link rel="stylesheet" type="text/css" href="style_admin.css">
    <style>
        .form-box { max-width: 400px; margin: 40px auto; background: #fff; border-radius: 12px; box-shadow: 0 4px 20px rgba(30,42,120,0.08); padding: 32px; }
        .form-title { font-size: 1.5em; font-weight: 700; color: #1e2a78; margin-bottom: 18px; text-align:center; }
        .form-group { margin-bottom: 18px; }
        label { font-weight: 700; color: #3a5eff; margin-bottom: 6px; display: block; }
        input, select { width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #c3e6cb; font-size: 1em; }
        .btn-submit { background: #3a5eff; color: #fff; border: none; border-radius: 10px; padding: 12px 24px; font-weight: 700; font-size: 1.1em; margin-top: 10px; cursor: pointer; width:100%; }
        .btn-submit:hover { background: #1e2a78; }
    </style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>
<div class="content">
    <div class="form-box">
        <div class="form-title">Edit Data Kamar</div>
        <form method="post">
            <div class="form-group">
                <label for="nama">Nama Kamar</label>
                <input type="text" name="nama" id="nama" value="<?= htmlspecialchars($kamar['nama']) ?>" required>
            </div>
            <div class="form-group">
                <label for="tipe">Tipe Kamar</label>
                <select name="tipe" id="tipe" required onchange="updateHarga()">
                    <option value="Deluxe" <?= $kamar['tipe']=='Deluxe'?'selected':'' ?>>Deluxe</option>
                    <option value="Superior" <?= $kamar['tipe']=='Superior'?'selected':'' ?>>Superior</option>
                </select>
            </div>
            <div class="form-group">
                <label for="harga">Harga</label>
                <input type="number" name="harga" id="harga" value="<?= htmlspecialchars($kamar['harga']) ?>" required>
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select name="status" id="status" required>
                    <option value="tersedia" <?= $kamar['status']=='tersedia'?'selected':'' ?>>Tersedia</option>
                    <option value="tidak tersedia" <?= $kamar['status']=='tidak tersedia'?'selected':'' ?>>Tidak Tersedia</option>
                    <option value="terisi" <?= $kamar['status']=='terisi'?'selected':'' ?>>Terisi</option>
                </select>
            </div>
            <button type="submit" class="btn-submit">Simpan Perubahan</button>
        </form>
    </div>
</div>
<?php include 'footer.php'; ?>
<script>
function updateHarga() {
    var tipe = document.getElementById('tipe').value;
    var hargaInput = document.getElementById('harga');
    if(tipe === 'Deluxe') hargaInput.value = 1000000;
    else if(tipe === 'Superior') hargaInput.value = 850000;
}
</script>
</body>
</html> 