<?php session_start(); if(!isset($_SESSION['admin_id'])){ header('Location: login.php'); exit; } ?>
<?php
include '../config/koneksi.php';
// Statistik kamar
$qTersedia = mysqli_query($conn, "SELECT COUNT(*) as jml FROM kamar WHERE status='tersedia'");
$tersedia = mysqli_fetch_assoc($qTersedia)['jml'] ?? 0;
$qTerisi = mysqli_query($conn, "SELECT COUNT(*) as jml FROM kamar WHERE status='terisi'");
$terisi = mysqli_fetch_assoc($qTerisi)['jml'] ?? 0;
// Statistik user
$qUser = mysqli_query($conn, "SELECT COUNT(*) as jml FROM user");
$userAktif = mysqli_fetch_assoc($qUser)['jml'] ?? 0;
// Statistik request layanan baru
$qReqBaru = mysqli_query($conn, "SELECT COUNT(*) as jml FROM layanan_request WHERE status='Menunggu'");
$requestBaru = mysqli_fetch_assoc($qReqBaru)['jml'] ?? 0;
// Request layanan terbaru
$requestTerbaru = [];
$qReqTerbaru = mysqli_query($conn, "SELECT * FROM layanan_request ORDER BY created_at DESC LIMIT 5");
while($r = mysqli_fetch_assoc($qReqTerbaru)) $requestTerbaru[] = $r;
?>
<!DOCTYPE html>
<html>
<head>
    <title>Beranda Admin - Ang Mansion</title>
    <link rel="stylesheet" type="text/css" href="style_admin.css">
</head>
<body>
<div class="header">
    <div class="logo">
        <img src="../assets/images/LogoAngMansion-Putih.png" alt="Logo" style="height:38px;margin-right:10px;"> AngMansion
    </div>
    <div style="margin-right:30px;font-size:1.1em;font-weight:600;">Admin Panel</div>
</div>
<?php include 'sidebar.php'; ?>
<div class="content">
    <div class="box" style="margin-bottom:30px;">
        <h2 style="text-align:center;">Selamat Datang, <?php echo $_SESSION['admin_user'] ?? 'Admin'; ?>!</h2>
        <p style="text-align:center;">Dashboard AngMansion - pantau data kos secara real-time.</p>
    </div>
    <div class="dashboard-stats">
        <div class="stat-card">
            <div class="stat-title">Kamar Tersedia</div>
            <div class="stat-value"><?php echo $tersedia; ?></div>
        </div></a>
        <div class="stat-card">
            <div class="stat-title">Kamar Terisi</div>
            <div class="stat-value"><?php echo $terisi; ?></div>
        </div></a>
        <div class="stat-card">
            <div class="stat-title">User Aktif</div>
            <div class="stat-value"><?php echo $userAktif; ?></div>
        </div></a>
        <div class="stat-card">
            <div class="stat-title">Request Layanan Baru</div>
            <div class="stat-value"><?php echo $requestBaru; ?></div>
        </div></a>
    </div>
    <div class="box" style="margin-top:30px;">
        <h3>Request Layanan Terbaru</h3>
        <ul>
            <?php foreach($requestTerbaru as $req): ?>
                <li><?php echo htmlspecialchars($req['jenis_layanan']); ?> - <?php echo htmlspecialchars($req['status']); ?> (<?php echo date('d-m-Y', strtotime($req['created_at'])); ?>)</li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>
<?php include 'footer.php'; ?>
</body>
</html> 