<?php
include '../config/koneksi.php';
session_start();
if(!isset($_SESSION['admin_id'])){
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Cetak Laporan Transaksi Sukses</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; }
        h2 { text-align: center; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #333; padding: 8px; text-align: center; }
        th { background: #f0f0f0; }
        @media print {
            button { display: none; }
        }
    </style>
</head>
<body onload="window.print()">
    <h2>Laporan Transaksi Sukses</h2>
    <table>
        <tr>
            <th>ID</th>
            <th>Tgl</th>
            <th>Tipe</th>
            <th>Harga</th>
            <th>Jumlah</th>
            <th>Nama</th>
            <th>Telepon</th>
            <th>Tanggal Masuk</th>
            <th>Tanggal Keluar</th>
            <th>Lama</th>
            <th>Total</th>
        </tr>
        <?php
        $q = mysqli_query($conn, "SELECT p.*, u.nama, u.telepon, k.tipe, k.harga FROM pemesanan p JOIN user u ON p.id_user=u.id JOIN kamar k ON p.id_kamar=k.id WHERE p.status='lunas' ORDER BY p.id DESC");
        while($d = mysqli_fetch_assoc($q)){
            $lama = (strtotime($d['tanggal_keluar'])-strtotime($d['tanggal_masuk']))/86400;
            $bulan = ceil($lama / 30); // Pembulatan ke atas, minimal 1 bulan
            echo '<tr>';
            echo '<td>'.$d['id'].'</td>';
            echo '<td>'.$d['tanggal_pesan'].'</td>';
            echo '<td>'.$d['tipe'].'</td>';
            echo '<td>Rp'.number_format($d['harga'],0,',','.').'</td>';
            echo '<td>1</td>';
            echo '<td>'.htmlspecialchars($d['nama']).'</td>';
            echo '<td>'.htmlspecialchars($d['telepon']).'</td>';
            echo '<td>'.$d['tanggal_masuk'].'</td>';
            echo '<td>'.$d['tanggal_keluar'].'</td>';
            echo '<td>'.$lama.' Hari</td>';
            echo '<td>Rp'.number_format($d['harga']*$bulan,0,',','.').'</td>';
            echo '</tr>';
        }
        ?>
    </table>
    <div style="text-align:center;margin-top:30px;">
        <button onclick="window.print()">Cetak</button>
        <button onclick="window.close()">Tutup</button>
    </div>
</body>
</html> 