<?php
// Script untuk menambahkan kolom foto ke tabel user
include 'config/koneksi.php';

echo "<h2>🔧 Script Penambahan Kolom Foto</h2>";

// Cek apakah kolom foto sudah ada
$checkColumn = mysqli_query($conn, "SHOW COLUMNS FROM user LIKE 'foto'");
if(mysqli_num_rows($checkColumn) == 0) {
    // Kolom foto belum ada, tambahkan
    $addColumn = mysqli_query($conn, "ALTER TABLE user ADD COLUMN foto VARCHAR(255) DEFAULT NULL");
    if($addColumn) {
        echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Kolom 'foto' berhasil ditambahkan ke tabel user!</div>";
    } else {
        echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Gagal menambahkan kolom 'foto': " . mysqli_error($conn) . "</div>";
    }
} else {
    echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ Kolom 'foto' sudah ada di tabel user!</div>";
}

// Cek struktur tabel user
echo "<h3>📋 Struktur Tabel User:</h3>";
$result = mysqli_query($conn, "DESCRIBE user");
if($result) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%; margin: 10px 0;'>";
    echo "<tr style='background: #f8f9fa;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Gagal mengambil struktur tabel: " . mysqli_error($conn) . "</div>";
}

// Cek direktori profile
$profileDir = 'assets/images/profile';
if(!is_dir($profileDir)) {
    if(mkdir($profileDir, 0755, true)) {
        echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Direktori profile berhasil dibuat: $profileDir</div>";
    } else {
        echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Gagal membuat direktori profile: $profileDir</div>";
    }
} else {
    echo "<div style='color: blue; padding: 10px; background: #d1ecf1; border-radius: 5px; margin: 10px 0;'>ℹ️ Direktori profile sudah ada: $profileDir</div>";
}

// Cek permission direktori
if(is_writable($profileDir)) {
    echo "<div style='color: green; padding: 10px; background: #d4edda; border-radius: 5px; margin: 10px 0;'>✅ Direktori profile dapat ditulis</div>";
} else {
    echo "<div style='color: red; padding: 10px; background: #f8d7da; border-radius: 5px; margin: 10px 0;'>❌ Direktori profile tidak dapat ditulis. Silakan set permission 755</div>";
}

echo "<br><a href='user/profile.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>🏠 Kembali ke Profile</a>";
?> 