# Ang Mansion - Sistem Pemesanan Kamar Kos

## Deskripsi
Ang Mansion adalah sistem pemesanan kamar kos modern yang menawarkan kenyamanan dan keamanan bagi para penghuni, dengan fasilitas lengkap dan lingkungan yang tenang.

## Fitur Utama

### 🏠 Halaman Beranda
- Tampilan fasilitas Ang Mansion
- Informasi tentang kos
- Peta lokasi
- Hero section yang menarik

### 👤 Manajemen User
- **Registrasi dan Login** - Sistem autentikasi yang aman
- **Profil User** - Manajemen data pribadi user
- **Upload Foto Profil** - Fitur upload dan update foto profil
  - Format yang didukung: JPG, PNG, GIF
  - Ukuran maksimal: 5MB
  - Foto otomatis di-crop menjadi persegi
  - Validasi file yang ketat
  - Hapus foto lama otomatis saat upload foto baru

### 🏢 Manajemen Kamar
- **Daftar Kamar** - Tampilan semua kamar yang tersedia
- **Detail Kamar** - Informasi lengkap setiap kamar
- **Pemesanan** - Sistem reservasi kamar
- **Stok Kamar** - Manajemen ketersediaan kamar

### 💰 Sistem Pembayaran
- **Konfirmasi Pembayaran** - Upload bukti pembayaran
- **Status Pembayaran** - Tracking status pembayaran
- **Riwayat Transaksi** - Histori semua transaksi

### 🛠️ Layanan
- **Request Layanan** - Permintaan layanan tambahan
- **Kontak** - Hubungi kami

### 👨‍💼 Panel Admin
- **Dashboard Admin** - Panel kontrol admin
- **Manajemen User** - Kelola data user
- **Manajemen Kamar** - Kelola data kamar
- **Laporan** - Cetak laporan transaksi
- **Konfirmasi Pembayaran** - Verifikasi pembayaran

## Teknologi yang Digunakan
- **Backend**: PHP Native
- **Database**: MySQL
- **Frontend**: HTML5, CSS3, JavaScript
- **Styling**: Custom CSS dengan desain modern
- **Icons**: Emoji dan SVG icons

## Instalasi

### Prerequisites
- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- Web server (Apache/Nginx)

### Langkah Instalasi
1. Clone repository ini
2. Import database dari file `sql/angmansion_kos.sql`
3. Konfigurasi database di `config/koneksi.php`
4. Pastikan folder `assets/images/profile` memiliki permission write (755)
5. Jalankan script `add_foto_column.php` untuk menambahkan kolom foto jika belum ada
6. Akses website melalui browser

## Struktur Database

### Tabel User
- `id` - Primary key
- `nama` - Nama lengkap user
- `email` - Email user (unique)
- `password` - Password terenkripsi
- `alamat` - Alamat user
- `telepon` - Nomor telepon
- `foto` - Nama file foto profil (VARCHAR 255)

### Tabel Kamar
- `id` - Primary key
- `nama` - Nama kamar
- `tipe` - Tipe kamar
- `harga` - Harga sewa
- `stok` - Jumlah kamar tersedia
- `deskripsi` - Deskripsi kamar
- `foto` - Foto kamar

### Tabel Pemesanan
- `id` - Primary key
- `user_id` - Foreign key ke tabel user
- `kamar_id` - Foreign key ke tabel kamar
- `tanggal_masuk` - Tanggal mulai sewa
- `tanggal_keluar` - Tanggal selesai sewa
- `status` - Status pemesanan
- `total_harga` - Total harga sewa

## Fitur Upload Foto Profil

### Cara Kerja
1. User mengakses halaman profil
2. User memilih file foto (JPG, PNG, GIF, max 5MB)
3. Sistem memvalidasi file
4. Foto lama dihapus otomatis (jika ada)
5. Foto baru diupload ke `assets/images/profile/`
6. Nama file disimpan ke database
7. Foto ditampilkan di profil dan header

### Validasi
- **Ukuran file**: Maksimal 5MB
- **Format file**: JPG, JPEG, PNG, GIF
- **Tipe MIME**: image/jpeg, image/jpg, image/png, image/gif
- **Nama file**: Otomatis generate dengan format `user_{id}_{timestamp}.{ext}`

### Keamanan
- Validasi tipe file yang ketat
- Sanitasi nama file
- Pengecekan permission direktori
- Error handling yang komprehensif

## File Penting

### Core Files
- `config/koneksi.php` - Konfigurasi database
- `user/profile.php` - Halaman profil user dengan upload foto
- `user/header.php` - Header untuk halaman user
- `assets/style_user.css` - Styling untuk user interface

### Utility Files
- `add_foto_column.php` - Script untuk menambahkan kolom foto
- `test_upload_foto.php` - File test untuk fitur upload foto

## Troubleshooting

### Masalah Upload Foto
1. **Kolom foto tidak ada**: Jalankan `add_foto_column.php`
2. **Permission error**: Set permission 755 untuk folder `assets/images/profile`
3. **File tidak terupload**: Cek ukuran file dan format
4. **Foto tidak muncul**: Cek path file dan permission

### Masalah Database
1. **Koneksi gagal**: Cek konfigurasi di `config/koneksi.php`
2. **Tabel tidak ada**: Import database dari `sql/angmansion_kos.sql`

## Kontribusi
Silakan berkontribusi dengan membuat pull request atau melaporkan bug melalui issues.

## Lisensi
Copyright © 2025 Ang Mansion. All Rights Reserved. 